/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.admin;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.ComboBoxItem;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.form.fields.events.ChangedEvent;
import com.smartgwt.client.widgets.form.fields.events.ChangedHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;
import java.util.Collection;
import org.modeshape.web.client.admin.AdminView;
import org.modeshape.web.client.chart.Chart;
import org.modeshape.web.shared.Stats;

public class Metrics
extends VLayout {
    private final Chart chart1 = new Chart("");
    private final Chart chart2 = new Chart("");
    private final DynamicForm f1 = new DynamicForm();
    private final DynamicForm f2 = new DynamicForm();
    private final ComboBoxItem cb1 = new ComboBoxItem("Select parameter");
    private final ComboBoxItem cb2 = new ComboBoxItem("Select parameter");
    private final ComboBoxItem tw1 = new ComboBoxItem("Time window");
    private final ComboBoxItem tw2 = new ComboBoxItem("Time window");
    private final AdminView adminView;

    public Metrics(AdminView adminView) {
        this.adminView = adminView;
        this.setHeight(500);
        this.setWidth100();
        VLayout strut = new VLayout();
        strut.setHeight(30);
        this.addMember((Canvas)strut);
        this.loadValueMetrics();
        this.loadDurationMetrics();
        this.loadTimeUnits();
        this.cb1.addChangedHandler(new ChangedHandler(){

            public void onChanged(ChangedEvent event) {
                Metrics.this.drawChart1();
            }
        });
        this.tw1.addChangedHandler(new ChangedHandler(){

            public void onChanged(ChangedEvent event) {
                Metrics.this.drawChart1();
            }
        });
        this.cb2.addChangedHandler(new ChangedHandler(){

            public void onChanged(ChangedEvent event) {
                Metrics.this.drawChart2();
            }
        });
        this.tw2.addChangedHandler(new ChangedHandler(){

            public void onChanged(ChangedEvent event) {
                Metrics.this.drawChart2();
            }
        });
        this.f1.setItems(new FormItem[]{this.cb1, this.tw1});
        this.f2.setItems(new FormItem[]{this.cb2, this.tw2});
        HLayout layout = new HLayout();
        layout.setWidth100();
        layout.setHeight100();
        VLayout p1 = new VLayout();
        VLayout p2 = new VLayout();
        this.addMember((Canvas)layout);
        layout.addMember((Canvas)p1);
        layout.addMember((Canvas)p2);
        this.chart1.setHeight100();
        this.chart2.setHeight100();
        this.chart1.setWidth100();
        this.chart2.setWidth100();
        p1.addMember((Canvas)this.f1);
        p1.addMember((Canvas)this.chart1);
        p2.addMember((Canvas)this.f2);
        p2.addMember((Canvas)this.chart2);
    }

    private void loadValueMetrics() {
        this.adminView.jcrService().getValueMetrics(new AsyncCallback<String[]>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(String[] result) {
                Metrics.this.cb1.setValueMap(result);
            }
        });
    }

    private void loadDurationMetrics() {
        this.adminView.jcrService().getDurationMetrics(new AsyncCallback<String[]>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(String[] result) {
                Metrics.this.cb2.setValueMap(result);
            }
        });
    }

    private void loadTimeUnits() {
        this.adminView.jcrService().getTimeUnits(new AsyncCallback<String[]>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(String[] result) {
                Metrics.this.tw1.setValueMap(result);
                Metrics.this.tw2.setValueMap(result);
                Metrics.this.tw1.setValue(result[0]);
                Metrics.this.tw2.setValue(result[0]);
            }
        });
    }

    private void drawChart1() {
        this.drawValueHistory(this.chart1, this.cb1.getValueAsString(), this.tw1.getValueAsString());
    }

    private void drawChart2() {
        this.drawDurationHistory(this.chart2, this.cb2.getValueAsString(), this.tw2.getValueAsString());
    }

    private void drawValueHistory(final Chart chart, String param, String time) {
        this.adminView.jcrService().getValueStats(this.adminView.repository(), param, time, new AsyncCallback<Collection<Stats>>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Collection<Stats> stats) {
                Metrics.this.drawHistory(chart, stats);
            }
        });
    }

    private void drawDurationHistory(final Chart chart, String param, String time) {
        this.adminView.jcrService().getDurationStats(this.adminView.repository(), param, time, new AsyncCallback<Collection<Stats>>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Collection<Stats> stats) {
                Metrics.this.drawHistory(chart, stats);
            }
        });
    }

    private void drawHistory(Chart chart, Collection<Stats> stats) {
        double[] x = new double[stats.size()];
        double[] y1 = new double[stats.size()];
        double[] y2 = new double[stats.size()];
        double[] y3 = new double[stats.size()];
        int c = stats.size() > 24 ? 24 : stats.size();
        int dx = stats.size() / c;
        String[] xl = new String[c];
        int i = 0;
        for (Stats s : stats) {
            x[i] = i;
            y1[i] = s.min();
            y2[i] = s.max();
            y3[i] = s.avg();
            ++i;
        }
        for (int j = 0; j < xl.length; ++j) {
            xl[j] = Integer.toString(j * dx);
        }
        chart.drawChart(xl, x, y1, y2, y3);
    }
}

