/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.admin;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.layout.VLayout;
import org.modeshape.web.client.admin.AdminView;
import org.modeshape.web.client.admin.RestoreDialog;
import org.modeshape.web.shared.RestoreParams;

public class RestoreControl
extends VLayout {
    private final AdminView adminView;
    private final RestoreDialog restoreDialog = new RestoreDialog(this);

    public RestoreControl(AdminView adminView) {
        this.adminView = adminView;
        this.setStyleName("admin-control");
        Label label = new Label("Restore");
        label.setIcon("icons/documents.png");
        label.setStyleName("button-label");
        label.setHeight(25);
        label.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                RestoreControl.this.restoreDialog.showModal();
            }
        });
        Canvas text = new Canvas();
        text.setAutoHeight();
        text.setContents("Once you have a complete backup on disk, you can then restore a repository back to the state captured within the backup. To do that, simply start a repository (or perhaps a new instance of a repository with a different configuration) and, before it\u2019s used by any applications, load into the new repository all of the content in the backup. ");
        this.addMember((Canvas)label);
        this.addMember(text);
    }

    public void restore(String name, RestoreParams params) {
        this.adminView.jcrService().restore(this.adminView.repository(), name, params, new AsyncCallback(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
            }
        });
    }
}

