/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.contents;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.smartgwt.client.util.BooleanCallback;
import com.smartgwt.client.util.SC;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.layout.VLayout;
import java.util.Date;
import java.util.HashMap;
import org.modeshape.web.client.Console;
import org.modeshape.web.client.JcrServiceAsync;
import org.modeshape.web.client.contents.AddNodeDialog;
import org.modeshape.web.client.contents.BinaryEditor;
import org.modeshape.web.client.contents.ChildrenEditor;
import org.modeshape.web.client.contents.ContentsLayout;
import org.modeshape.web.client.contents.DetailsLayout;
import org.modeshape.web.client.contents.ExportDialog;
import org.modeshape.web.client.contents.ImportDialog;
import org.modeshape.web.client.contents.PathControl;
import org.modeshape.web.client.contents.PermissionsEditor;
import org.modeshape.web.client.contents.PropertiesEditor;
import org.modeshape.web.client.contents.Session;
import org.modeshape.web.client.contents.WorkspacePanel;
import org.modeshape.web.shared.BaseCallback;
import org.modeshape.web.shared.JcrNode;
import org.modeshape.web.shared.JcrPermission;
import org.modeshape.web.shared.JcrProperty;
import org.modeshape.web.shared.RemoteException;

public class Contents
extends VLayout {
    private static final String ROOT_PATH = "/";
    private Console console;
    private String repository;
    private JcrNode node;
    private String path;
    private WorkspacePanel wsp = new WorkspacePanel(this);
    private PathControl pathLabel = new PathControl(this);
    private ChildrenEditor childrenEditor = new ChildrenEditor(this);
    private PropertiesEditor propertiesEditor = new PropertiesEditor(this);
    private PermissionsEditor permissionsEditor = new PermissionsEditor(this);
    private BinaryEditor binaryEditor = new BinaryEditor();
    private DetailsLayout details = new DetailsLayout(this.propertiesEditor, this.permissionsEditor);
    private ContentsLayout contentsLayout = new ContentsLayout(this.childrenEditor, this.binaryEditor, this.details);
    private final AddNodeDialog addNodeDialog = new AddNodeDialog(this);
    private final ExportDialog exportDialog = new ExportDialog(this);
    private final ImportDialog importDialog = new ImportDialog(this);
    private final HashMap<String, Session> sessions = new HashMap();

    public Contents(Console console) {
        this.console = console;
        this.addMember(this.description());
        this.addMember((Canvas)new Spacer(20));
        this.addMember((Canvas)this.wsp);
        this.addMember((Canvas)new Spacer(20));
        this.addMember((Canvas)this.pathLabel);
        this.addMember((Canvas)this.contentsLayout);
    }

    private Canvas description() {
        Canvas text = new Canvas();
        text.setContents("ModeShape is a distributed, hierarchical, transactional, and consistent data store with support for queries, full-text search, events, versioning, references, and flexible and dynamic schemas. It is very fast, highly available, extremely scalable, and it is 100% open source and written in Java. Clients use the JSR-283 standard Java API for content repositories (aka, JCR) or ModeShape's REST API, and can query content through JDBC and SQL.");
        text.setWidth100();
        text.setAutoHeight();
        text.setStyleName("caption");
        return text;
    }

    private Session session() {
        Session s = this.sessions.get(this.repository() + "$" + this.workspace());
        if (s == null) {
            s = new Session();
            this.sessions.put(this.repository() + "$" + this.workspace(), s);
        }
        return s;
    }

    public JcrServiceAsync jcrService() {
        return this.console.jcrService();
    }

    private void showLoadIcon() {
        this.pathLabel.setVisible(false);
        this.contentsLayout.setVisible(false);
        this.console.showLoadingIcon();
    }

    private void hideLoadIcon() {
        this.console.hideLoadingIcon();
        this.pathLabel.setVisible(true);
        this.contentsLayout.setVisible(true);
    }

    protected void toggleDetails() {
        this.contentsLayout.setShowDetails(!this.contentsLayout.showDetails());
    }

    public void changeWorkspace(String name) {
        this.getAndDisplayNode(ROOT_PATH, true);
        this.updateControls();
    }

    public void show(String repository, boolean changeHistory) {
        this.repository = repository;
        this.refreshWorkspacesAndReloadNode(null, ROOT_PATH, changeHistory);
    }

    public void show(String repository, String workspace, String path, boolean changeHistory) {
        this.repository = repository;
        this.refreshWorkspacesAndReloadNode(null, path, changeHistory);
    }

    private void refreshWorkspacesAndReloadNode(String name, final String path, final boolean changeHistory) {
        this.showLoadIcon();
        this.console.jcrService().getWorkspaces(this.repository, new AsyncCallback<String[]>(){

            public void onFailure(Throwable caught) {
                Contents.this.hideLoadIcon();
                RemoteException e = (RemoteException)caught;
                SC.say((String)caught.getMessage());
                if (e.code() == 1) {
                    Contents.this.console.loadRepositoriesList();
                }
            }

            public void onSuccess(String[] workspaces) {
                Contents.this.wsp.setWorkspaceNames(workspaces);
                Contents.this.getAndDisplayNode(path, changeHistory);
                Contents.this.hideLoadIcon();
            }
        });
    }

    public void getAndDisplayNode(final String path, final boolean changeHistory) {
        this.showLoadIcon();
        this.console.jcrService().node(this.repository(), this.workspace(), path, new AsyncCallback<JcrNode>(){

            public void onFailure(Throwable caught) {
                Contents.this.hideLoadIcon();
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(JcrNode node) {
                Contents.this.displayNode(node);
                Contents.this.console.changeWorkspaceInURL(Contents.this.workspace(), changeHistory);
                Contents.this.console.changePathInURL(path, changeHistory);
                Contents.this.hideLoadIcon();
            }
        });
    }

    private void displayNode(JcrNode node) {
        this.node = node;
        this.path = node.getPath();
        this.pathLabel.display(node.getPath());
        this.childrenEditor.show(node);
        this.propertiesEditor.show(node);
        this.permissionsEditor.show(node);
        this.displayBinaryContent(node);
    }

    private void displayBinaryContent(JcrNode node) {
        this.binaryEditor.setVisible(false);
        for (JcrProperty property : node.getProperties()) {
            if (!property.isBinary()) continue;
            this.binaryEditor.setVisible(true);
            this.binaryEditor.setValue(node, property.getName(), property.getValue());
        }
    }

    public void save() {
        SC.ask((String)"Do you want to save changes", (BooleanCallback)new BooleanCallback(){

            public void execute(Boolean yesSelected) {
                if (yesSelected.booleanValue()) {
                    Contents.this.jcrService().save(Contents.this.repository(), Contents.this.workspace(), new BaseCallback<Object>(){

                        public void onSuccess(Object result) {
                            Contents.this.session().setHasChanges(false);
                            Contents.this.updateControls();
                        }
                    });
                }
            }
        });
    }

    public void refreshSession(boolean keepChanges) {
        this.console.jcrService().refreshSession(this.repository(), this.workspace(), keepChanges, new AsyncCallback(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.getAndDisplayNode(Contents.this.path(), true);
            }
        });
    }

    public void showAddNodeDialog() {
        this.jcrService().getPrimaryTypes(this.node.getRepository(), this.node.getWorkspace(), null, false, new AsyncCallback<String[]>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(String[] result) {
                Contents.this.addNodeDialog.setPrimaryTypes(result);
                Contents.this.addNodeDialog.showModal();
            }
        });
    }

    public void showExportDialog() {
        this.exportDialog.showModal();
    }

    public void showImportDialog() {
        this.importDialog.showModal();
    }

    public void exportXML(String name, boolean skipBinary, boolean noRecurse) {
        this.console.jcrService().export(this.repository, this.workspace(), this.path(), name, true, true, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                SC.say((String)"Complete");
            }
        });
    }

    public void importXML(String name, int option) {
        this.console.jcrService().importXML(this.repository, this.workspace(), this.path(), name, option, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                SC.say((String)"Complete");
            }
        });
    }

    public void removeNode(JcrNode node) {
        final String parent = this.parent(node.getPath());
        this.console.jcrService().removeNode(this.repository(), this.workspace(), node.getPath(), new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.session().setHasChanges(true);
                Contents.this.getAndDisplayNode(parent, true);
                Contents.this.updateControls();
            }
        });
    }

    public void addMixin(String name) {
        this.console.jcrService().addMixin(this.repository(), this.workspace(), this.path(), name, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.session().setHasChanges(true);
                Contents.this.show();
                Contents.this.updateControls();
            }
        });
    }

    public void removeMixin(String name) {
        this.console.jcrService().removeMixin(this.repository(), this.workspace(), this.path(), name, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.session().setHasChanges(true);
                Contents.this.show();
                Contents.this.updateControls();
            }
        });
    }

    public void setNodeProperty(JcrNode node, String name, Boolean value) {
        this.console.jcrService().setProperty(node, name, value, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.session().setHasChanges(true);
                Contents.this.show();
                Contents.this.updateControls();
            }
        });
    }

    public void setNodeProperty(JcrNode node, String name, Date value) {
        this.console.jcrService().setProperty(node, name, value, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.session().setHasChanges(true);
                Contents.this.show();
                Contents.this.updateControls();
            }
        });
    }

    public void setNodeProperty(JcrNode node, String name, String value) {
        this.console.jcrService().setProperty(node, name, value, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.session().setHasChanges(true);
                Contents.this.show();
                Contents.this.updateControls();
            }
        });
    }

    protected void addNode(String name, String primaryType) {
        this.console.jcrService().addNode(this.repository(), this.workspace(), this.path(), name, primaryType, new AsyncCallback<JcrNode>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(JcrNode node) {
                Contents.this.session().setHasChanges(true);
                Contents.this.getAndDisplayNode(Contents.this.path(), false);
                Contents.this.updateControls();
            }
        });
    }

    protected void renameNode(JcrNode node, String name) {
        this.console.jcrService().renameNode(this.repository(), this.workspace(), node.getPath(), name, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.session().setHasChanges(true);
                Contents.this.getAndDisplayNode(Contents.this.path(), false);
                Contents.this.updateControls();
            }
        });
    }

    public void addAccessList(String name) {
        this.console.jcrService().addAccessList(this.repository(), this.workspace(), this.path(), name, new AsyncCallback(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.session().setHasChanges(true);
                Contents.this.getAndDisplayNode(Contents.this.path(), false);
                Contents.this.updateControls();
            }
        });
    }

    public void updateAccessList(String principal, JcrPermission permission, boolean enabled) {
        this.console.jcrService().updateAccessList(this.repository, this.workspace(), this.path(), principal, permission, enabled, new AsyncCallback<Object>(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.session().setHasChanges(true);
                Contents.this.getAndDisplayNode(Contents.this.path(), false);
                Contents.this.updateControls();
            }
        });
    }

    public void removeAccessList(String name) {
        this.console.jcrService().removeAccessList(this.repository(), this.workspace(), this.path(), name, new AsyncCallback(){

            public void onFailure(Throwable caught) {
                SC.say((String)caught.getMessage());
            }

            public void onSuccess(Object result) {
                Contents.this.session().setHasChanges(true);
                Contents.this.getAndDisplayNode(Contents.this.path(), false);
                Contents.this.updateControls();
            }
        });
    }

    public String repository() {
        return this.repository;
    }

    public String workspace() {
        return this.wsp.getSelectedWorkspace();
    }

    public JcrNode node() {
        return this.node;
    }

    public String path() {
        return this.path == null ? ROOT_PATH : this.path;
    }

    private String parent(String path) {
        if (path == null) {
            return ROOT_PATH;
        }
        if ((path = path.substring(0, path.lastIndexOf(47))).length() == 0) {
            return ROOT_PATH;
        }
        return path;
    }

    private void updateControls() {
        this.wsp.setEnabled(this.session().hasChanges());
    }

    private class Spacer
    extends VLayout {
        public Spacer(int size) {
            this.setHeight(size);
        }
    }
}

