/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.grid;

import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.DynamicForm;
import com.smartgwt.client.widgets.form.fields.FormItem;
import com.smartgwt.client.widgets.form.fields.TextItem;
import com.smartgwt.client.widgets.layout.HLayout;

public abstract class Pager
extends HLayout {
    private final Label[] pageNumber = new Label[10];
    private final TextItem itemsPerPageEditor = new TextItem("Nodes per page");
    private int pageTotal;

    public Pager() {
        this.setHeight(30);
        Label pageLabel = new Label();
        pageLabel.setContents("<b>Page:</b>");
        pageLabel.setMargin(Integer.valueOf(3));
        pageLabel.setAutoWidth();
        this.addMember((Canvas)pageLabel);
        for (int i = 0; i < this.pageNumber.length; ++i) {
            this.pageNumber[i] = new Label();
            this.pageNumber[i].setAutoWidth();
            this.pageNumber[i].addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    Label label = (Label)event.getSource();
                    String indexStr = label.getContents();
                    if (indexStr.equals("..")) {
                        return;
                    }
                    int index = Integer.parseInt(indexStr) - 1;
                    Pager.this.fetch(index);
                    Pager.this.draw(index);
                }
            });
            this.pageNumber[i].setMargin(Integer.valueOf(3));
            this.addMember((Canvas)this.pageNumber[i]);
        }
        this.itemsPerPageEditor.setWidth(50);
        this.itemsPerPageEditor.setValue("10");
        DynamicForm form = new DynamicForm();
        form.setHeight100();
        form.setWidth(200);
        form.setLayoutAlign(VerticalAlignment.CENTER);
        form.setItems(new FormItem[]{this.itemsPerPageEditor});
        Label strut = new Label();
        strut.setHeight100();
        strut.setWidth100();
        this.addMember((Canvas)strut);
        this.addMember((Canvas)form);
    }

    public void setRecordsAmount(int amount) {
        int ipp = Integer.parseInt(this.itemsPerPageEditor.getValueAsString());
        this.pageTotal = amount % ipp == 0 ? amount / ipp : amount / ipp + 1;
        this.draw(0);
    }

    public int getRecordsPerPage() {
        return Integer.parseInt(this.itemsPerPageEditor.getValueAsString());
    }

    public abstract void fetch(int var1);

    private void draw(int index) {
        int i;
        for (i = 0; i < this.pageNumber.length; ++i) {
            this.pageNumber[i].setVisible(false);
        }
        if (this.pageTotal <= this.pageNumber.length) {
            for (i = 0; i < this.pageTotal; ++i) {
                this.pageNumber[i].setContents(Integer.toString(i + 1));
                this.pageNumber[i].setVisible(true);
            }
        } else if (index < this.pageTotal / 2) {
            this.pageNumber[0].setContents("1");
            this.pageNumber[0].setVisible(true);
            for (i = 1; i < this.pageNumber.length - 1; ++i) {
                this.pageNumber[i].setContents(Integer.toString(i + 1));
                this.pageNumber[i].setVisible(true);
            }
            this.pageNumber[this.pageNumber.length - 2].setContents("..");
            this.pageNumber[this.pageNumber.length - 2].setVisible(true);
            this.pageNumber[this.pageNumber.length - 1].setContents(Integer.toString(this.pageTotal));
            this.pageNumber[this.pageNumber.length - 1].setVisible(true);
        } else {
            this.pageNumber[0].setContents("1");
            this.pageNumber[0].setVisible(true);
            this.pageNumber[1].setContents("..");
            this.pageNumber[1].setVisible(true);
            for (i = 2; i < this.pageNumber.length - 1; ++i) {
                this.pageNumber[i].setContents(Integer.toString(i + 1));
                this.pageNumber[i].setVisible(true);
            }
        }
        String idx = Integer.toString(index + 1);
        for (int i2 = 0; i2 < this.pageNumber.length; ++i2) {
            if (this.pageNumber[i2].getContents().equals(idx)) {
                this.pageNumber[i2].setStyleName("page-index-selected");
                continue;
            }
            this.pageNumber[i2].setStyleName("page-index");
        }
    }
}

