/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.client.repo;

import com.smartgwt.client.types.Alignment;
import com.smartgwt.client.types.VerticalAlignment;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.Img;
import com.smartgwt.client.widgets.Label;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.layout.HLayout;
import com.smartgwt.client.widgets.layout.VLayout;
import org.modeshape.web.client.Console;
import org.modeshape.web.client.admin.AdminView;
import org.modeshape.web.client.nt.NodeTypesModalForm;
import org.modeshape.web.client.query.QueryModalForm;
import org.modeshape.web.client.repo.DescriptorModalForm;

public class RepositoryHeader
extends HLayout {
    private static final int HEIGHT = 55;
    private static final int LOGO_WIDTH = 45;
    private Label label = new Label();
    private String repositoryName;
    private HLayout mainLayout = new HLayout();
    private final Console console;
    private final NodeTypesModalForm ntForm;
    private final QueryModalForm queryForm;
    private final DescriptorModalForm descriptorForm;
    private final AdminView adminView;

    public RepositoryHeader(final Console console) {
        this.console = console;
        this.ntForm = new NodeTypesModalForm(console);
        this.queryForm = new QueryModalForm(console);
        this.descriptorForm = new DescriptorModalForm(console);
        this.adminView = new AdminView(console);
        this.alignAndResize();
        this.addMember((Canvas)new Strut(10));
        this.addMember((Canvas)this.mainLayout);
        this.addMember((Canvas)new Strut(10));
        this.mainLayout.setWidth("80%");
        this.mainLayout.setHeight(55);
        HLayout col1 = new HLayout();
        col1.setLayoutAlign(VerticalAlignment.CENTER);
        col1.setDefaultLayoutAlign(VerticalAlignment.CENTER);
        col1.setWidth100();
        VLayout col2 = new VLayout();
        col2.setHeight(30);
        col2.setLayoutAlign(Alignment.RIGHT);
        col2.setDefaultLayoutAlign(Alignment.RIGHT);
        col2.setDefaultLayoutAlign(VerticalAlignment.CENTER);
        col2.setLayoutAlign(VerticalAlignment.CENTER);
        col2.setAlign(Alignment.RIGHT);
        col2.setAutoWidth();
        this.mainLayout.addMember((Canvas)col1);
        this.mainLayout.addMember((Canvas)col2);
        this.label.setStyleName("repository-caption");
        this.label.setWidth("100%");
        this.label.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                console.loadRepositoriesList();
            }
        });
        this.label.setValign(VerticalAlignment.CENTER);
        col1.addMember((Canvas)new RepositoryIcon(45, 55));
        col1.addMember((Canvas)this.label);
        col2.addMember((Canvas)new Toolbar(console));
    }

    private void alignAndResize() {
        this.setStyleName("repository");
        this.setLayoutAlign(Alignment.CENTER);
        this.setLayoutAlign(VerticalAlignment.CENTER);
        this.setDefaultLayoutAlign(Alignment.CENTER);
        this.setDefaultLayoutAlign(VerticalAlignment.CENTER);
        this.setHeight(55);
        this.setWidth100();
    }

    public void setLayoutWidth(String value) {
        this.mainLayout.setWidth(value);
    }

    public String repository() {
        return this.repositoryName;
    }

    public void show(String name) {
        this.repositoryName = name;
        this.label.setContents("Repository: " + name);
        this.show();
    }

    public void showRepositoryInfo() {
        this.descriptorForm.showModal();
    }

    public void showNodeTypes() {
        this.ntForm.showModal();
    }

    public void showContent() {
        this.console.loadNodeSpecifiedByURL();
    }

    public void showQuery() {
        this.queryForm.showModal();
    }

    public void showAdmin() {
        this.console.display((Canvas)this.adminView);
    }

    private class Strut
    extends VLayout {
        public Strut(int size) {
            this.setHeight(size);
        }
    }

    private class Spacer
    extends HLayout {
        protected Spacer(int size) {
            this.setWidth(size);
        }
    }

    private class ToolButton
    extends Label {
        public ToolButton(String title) {
            super("<b>" + title + "</b>");
            this.setAlign(Alignment.RIGHT);
            this.setAutoWidth();
            this.setStyleName("tab-label");
        }
    }

    private class Toolbar
    extends HLayout {
        public Toolbar(Console console) {
            this.setHeight(30);
            this.setLayoutAlign(Alignment.RIGHT);
            this.setDefaultLayoutAlign(Alignment.RIGHT);
            this.setAlign(Alignment.RIGHT);
            this.setStyleName("viewport");
            this.setAutoWidth();
            ToolButton explore = new ToolButton("Explore");
            explore.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    RepositoryHeader.this.showContent();
                }
            });
            ToolButton nodeTypes = new ToolButton("NodeTypes");
            nodeTypes.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    RepositoryHeader.this.showNodeTypes();
                }
            });
            ToolButton descriptor = new ToolButton("Descriptor");
            descriptor.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    RepositoryHeader.this.showRepositoryInfo();
                }
            });
            ToolButton query = new ToolButton("Query");
            query.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    RepositoryHeader.this.showQuery();
                }
            });
            ToolButton admin = new ToolButton("Admin");
            admin.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    RepositoryHeader.this.showAdmin();
                }
            });
            this.addMember((Canvas)new Spacer(10));
            this.addMember((Canvas)explore);
            this.addMember((Canvas)new Spacer(10));
            this.addMember((Canvas)nodeTypes);
            this.addMember((Canvas)new Spacer(10));
            this.addMember((Canvas)descriptor);
            this.addMember((Canvas)new Spacer(10));
            this.addMember((Canvas)query);
            this.addMember((Canvas)new Spacer(10));
            this.addMember((Canvas)admin);
            this.addMember((Canvas)new Spacer(10));
            this.setHeight(30);
        }
    }

    private class RepositoryIcon
    extends Img {
        private static final String IMG_PATH = "icons/attach.png";

        public RepositoryIcon(int width, int height) {
            this.setSrc(IMG_PATH);
            this.setWidth(width);
            this.setHeight(height);
            this.setValign(VerticalAlignment.CENTER);
        }
    }
}

