/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.shared;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.modeshape.web.shared.JcrPermission;

public class Policy
implements Serializable {
    private JcrPermission LIFECYCLE_MANAGEMENT = new JcrPermission("{http://www.jcp.org/jcr/1.0}lifecycleManagement", "Life cycle management");
    private JcrPermission LOCK_MANAGEMENT = new JcrPermission("{http://www.jcp.org/jcr/1.0}lockManagement", "Lock management");
    private JcrPermission NODE_TYPE_MANAGEMENT = new JcrPermission("{http://www.jcp.org/jcr/1.0}nodeTypeManagement", "Node type management");
    private JcrPermission RETENTION_MANAGEMENT = new JcrPermission("{http://www.jcp.org/jcr/1.0}retentionManagement", "Retention management");
    private JcrPermission VERSION_MANAGEMENT = new JcrPermission("{http://www.jcp.org/jcr/1.0}versionManagement", "Version management");
    private JcrPermission READ_ACCESS_CONTROL = new JcrPermission("{http://www.jcp.org/jcr/1.0}readAccessControl", "Read access control");
    private JcrPermission MODIFY_ACCESS_CONTROL = new JcrPermission("{http://www.jcp.org/jcr/1.0}modifyAccessControl", "Modify access control");
    private JcrPermission READ = new JcrPermission("{http://www.jcp.org/jcr/1.0}read", "Read");
    private JcrPermission ADD_CHILD_NODES = new JcrPermission("{http://www.jcp.org/jcr/1.0}addChildNodes", "Add child nodes");
    private JcrPermission REMOVE_CHILD_NODES = new JcrPermission("{http://www.jcp.org/jcr/1.0}removeChildNodes", "Remove child nodes");
    private JcrPermission MODIFY_PROPERTIES = new JcrPermission("{http://www.jcp.org/jcr/1.0}modifyProperties", "Modify properties");
    private JcrPermission WRITE = new JcrPermission("{http://www.jcp.org/jcr/1.0}write", "Write", this.ADD_CHILD_NODES, this.REMOVE_CHILD_NODES, this.MODIFY_PROPERTIES);
    private JcrPermission ALL = new JcrPermission("{http://www.jcp.org/jcr/1.0}all", "All permissions", this.LIFECYCLE_MANAGEMENT, this.LOCK_MANAGEMENT, this.NODE_TYPE_MANAGEMENT, this.RETENTION_MANAGEMENT, this.VERSION_MANAGEMENT, this.READ_ACCESS_CONTROL, this.MODIFY_ACCESS_CONTROL, this.READ, this.WRITE);
    private static final long serialVersionUID = 1L;
    private String principal;
    private JcrPermission[] PERMISSIONS = new JcrPermission[]{this.ALL, this.LIFECYCLE_MANAGEMENT, this.LOCK_MANAGEMENT, this.NODE_TYPE_MANAGEMENT, this.RETENTION_MANAGEMENT, this.VERSION_MANAGEMENT, this.READ_ACCESS_CONTROL, this.MODIFY_ACCESS_CONTROL, this.READ, this.WRITE, this.ADD_CHILD_NODES, this.MODIFY_PROPERTIES, this.REMOVE_CHILD_NODES};

    public String getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    public void enable(String name) {
        this.forName(name).setStatus(true);
    }

    public void disable(String name) {
        this.forName(name).setStatus(false);
    }

    public void disableAll() {
        for (int i = 0; i < this.PERMISSIONS.length; ++i) {
            this.PERMISSIONS[i].setStatus(false);
        }
    }

    public void enableAll() {
        for (int i = 0; i < this.PERMISSIONS.length; ++i) {
            this.PERMISSIONS[i].setStatus(true);
        }
    }

    public Collection<JcrPermission> permissions() {
        ArrayList<JcrPermission> list = new ArrayList<JcrPermission>();
        for (int i = 0; i < this.PERMISSIONS.length; ++i) {
            list.add(this.PERMISSIONS[i]);
        }
        return list;
    }

    public void modify(JcrPermission permission, boolean enabled) {
        permission.setStatus(enabled);
    }

    private JcrPermission forName(String name) {
        for (int i = 0; i < this.PERMISSIONS.length; ++i) {
            if (!this.PERMISSIONS[i].getName().equalsIgnoreCase(name)) continue;
            return this.PERMISSIONS[i];
        }
        return null;
    }

    public boolean hasPermission(JcrPermission permission) {
        for (JcrPermission p : this.PERMISSIONS) {
            if (!p.matches(permission)) continue;
            return true;
        }
        return false;
    }
}

