/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.modeshape.common.text.UrlEncoder;
import org.modeshape.web.jcr.rest.RepositoryFactory;

public abstract class AbstractJcrResource {
    protected static final UrlEncoder URL_ENCODER = new UrlEncoder();
    public static final String EMPTY_REPOSITORY_NAME = "<default>";
    public static final String EMPTY_WORKSPACE_NAME = "<default>";

    protected Session getSession(HttpServletRequest request, String rawRepositoryName, String rawWorkspaceName) throws RepositoryException {
        assert (request != null);
        return RepositoryFactory.getSession(request, this.repositoryNameFor(rawRepositoryName), this.workspaceNameFor(rawWorkspaceName));
    }

    private String workspaceNameFor(String rawWorkspaceName) {
        String workspaceName = URL_ENCODER.decode(rawWorkspaceName);
        if ("<default>".equals(workspaceName)) {
            workspaceName = "";
        }
        return workspaceName;
    }

    private String repositoryNameFor(String rawRepositoryName) {
        String repositoryName = URL_ENCODER.decode(rawRepositoryName);
        if ("<default>".equals(repositoryName)) {
            repositoryName = "";
        }
        return repositoryName;
    }
}

