/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeType;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import net.jcip.annotations.Immutable;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.modeshape.common.util.Base64;
import org.modeshape.web.jcr.rest.AbstractJcrResource;

@Immutable
@Path(value="/")
public class ItemsResource
extends AbstractJcrResource {
    private static final String BASE64_ENCODING_SUFFIX = "/base64/";
    private static final String PROPERTIES_HOLDER = "properties";
    private static final String CHILD_NODE_HOLDER = "children";
    private static final String PRIMARY_TYPE_PROPERTY = "jcr:primaryType";
    private static final String MIXIN_TYPES_PROPERTY = "jcr:mixinTypes";

    @GET
    @Path(value="/{repositoryName}/{workspaceName}/items{path:.*}")
    @Produces(value={"application/json"})
    public String getItem(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="path") String path, @QueryParam(value="mode:depth") @DefaultValue(value="0") int depth) throws JSONException, UnauthorizedException, RepositoryException {
        Node item;
        assert (path != null);
        assert (rawRepositoryName != null);
        assert (rawWorkspaceName != null);
        Session session = this.getSession(request, rawRepositoryName, rawWorkspaceName);
        if ("/".equals(path) || "".equals(path)) {
            item = session.getRootNode();
        } else {
            try {
                item = session.getItem(path);
            }
            catch (PathNotFoundException pnfe) {
                throw new NotFoundException(pnfe.getMessage(), (Throwable)pnfe);
            }
        }
        if (item instanceof Node) {
            return this.jsonFor(item, depth).toString();
        }
        return this.jsonFor((Property)item).toString();
    }

    private JSONObject jsonFor(Property property) throws JSONException, RepositoryException {
        boolean encoded = false;
        String valueObject = null;
        if (property.getDefinition().isMultiple()) {
            Value[] values;
            for (Value value : values = property.getValues()) {
                if (value.getType() != 2) continue;
                encoded = true;
                break;
            }
            ArrayList<String> list = new ArrayList<String>(values.length);
            if (encoded) {
                for (Value value : values) {
                    list.add(this.jsonEncodedStringFor(value));
                }
            } else {
                for (Value value : values) {
                    list.add(value.getString());
                }
            }
            valueObject = new JSONArray(list);
        } else {
            Value value = property.getValue();
            encoded = value.getType() == 2;
            valueObject = encoded ? this.jsonEncodedStringFor(value) : value.getString();
        }
        String propertyName = property.getName();
        if (encoded) {
            propertyName = propertyName + BASE64_ENCODING_SUFFIX;
        }
        JSONObject jsonProperty = new JSONObject();
        jsonProperty.put(propertyName, (Object)valueObject);
        return jsonProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String jsonEncodedStringFor(Value value) throws RepositoryException {
        InputStream stream = value.getStream();
        try {
            String string = Base64.encode((InputStream)stream);
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
        }
    }

    private JSONObject jsonFor(Node node, int toDepth) throws JSONException, RepositoryException {
        Node child;
        NodeIterator iter;
        JSONObject children;
        JSONObject jsonNode = new JSONObject();
        JSONObject properties = new JSONObject();
        PropertyIterator iter2 = node.getProperties();
        while (iter2.hasNext()) {
            Property prop = iter2.nextProperty();
            String propName = prop.getName();
            boolean encoded = false;
            if (prop.getDefinition().isMultiple()) {
                Value[] values;
                for (Value value : values = prop.getValues()) {
                    if (value.getType() != 2) continue;
                    encoded = true;
                    break;
                }
                if (encoded) {
                    propName = propName + BASE64_ENCODING_SUFFIX;
                }
                JSONArray array = new JSONArray();
                for (int i = 0; i < values.length; ++i) {
                    array.put((Object)(encoded ? this.jsonEncodedStringFor(values[i]) : values[i].getString()));
                }
                properties.put(propName, (Object)array);
                continue;
            }
            Value value = prop.getValue();
            boolean bl = encoded = value.getType() == 2;
            if (encoded) {
                propName = propName + BASE64_ENCODING_SUFFIX;
            }
            properties.put(propName, (Object)(encoded ? this.jsonEncodedStringFor(value) : value.getString()));
        }
        if (properties.length() > 0) {
            jsonNode.put(PROPERTIES_HOLDER, (Object)properties);
        }
        if (toDepth == 0) {
            children = new ArrayList();
            iter = node.getNodes();
            while (iter.hasNext()) {
                child = iter.nextNode();
                children.add(child.getName());
            }
            if (children.size() > 0) {
                jsonNode.put(CHILD_NODE_HOLDER, (Object)new JSONArray((Collection)children));
            }
        } else {
            children = new JSONObject();
            iter = node.getNodes();
            while (iter.hasNext()) {
                child = iter.nextNode();
                children.put(child.getName(), (Object)this.jsonFor(child, toDepth - 1));
            }
            if (children.length() > 0) {
                jsonNode.put(CHILD_NODE_HOLDER, (Object)children);
            }
        }
        return jsonNode;
    }

    @POST
    @Path(value="/{repositoryName}/{workspaceName}/items/{path:.*}")
    @Consumes(value={"application/json"})
    public Response postItem(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="path") String path, String requestContent) throws NotFoundException, UnauthorizedException, RepositoryException, JSONException {
        assert (rawRepositoryName != null);
        assert (rawWorkspaceName != null);
        assert (path != null);
        JSONObject body = new JSONObject(requestContent);
        int lastSlashInd = path.lastIndexOf(47);
        String parentPath = lastSlashInd == -1 ? "/" : "/" + path.substring(0, lastSlashInd);
        String newNodeName = lastSlashInd == -1 ? path : path.substring(lastSlashInd + 1);
        Session session = this.getSession(request, rawRepositoryName, rawWorkspaceName);
        Node parentNode = (Node)session.getItem(parentPath);
        Node newNode = this.addNode(parentNode, newNodeName, body);
        session.save();
        String json = this.jsonFor(newNode, -1).toString();
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)json).build();
    }

    private Node addNode(Node parentNode, String nodeName, JSONObject jsonNode) throws RepositoryException, JSONException {
        Node newNode;
        JSONObject properties;
        JSONObject jSONObject = properties = jsonNode.has(PROPERTIES_HOLDER) ? jsonNode.getJSONObject(PROPERTIES_HOLDER) : new JSONObject();
        if (properties.has(PRIMARY_TYPE_PROPERTY)) {
            String primaryType = properties.getString(PRIMARY_TYPE_PROPERTY);
            newNode = parentNode.addNode(nodeName, primaryType);
        } else {
            newNode = parentNode.addNode(nodeName);
        }
        if (properties.has(MIXIN_TYPES_PROPERTY)) {
            Object rawMixinTypes = properties.get(MIXIN_TYPES_PROPERTY);
            if (rawMixinTypes instanceof JSONArray) {
                JSONArray mixinTypes = (JSONArray)rawMixinTypes;
                for (int i = 0; i < mixinTypes.length(); ++i) {
                    newNode.addMixin(mixinTypes.getString(i));
                }
            } else {
                newNode.addMixin(rawMixinTypes.toString());
            }
        }
        Iterator iter = properties.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (PRIMARY_TYPE_PROPERTY.equals(key) || MIXIN_TYPES_PROPERTY.equals(key)) continue;
            this.setPropertyOnNode(newNode, key, properties.get(key));
        }
        if (jsonNode.has(CHILD_NODE_HOLDER)) {
            JSONObject children = jsonNode.getJSONObject(CHILD_NODE_HOLDER);
            Iterator iter2 = children.keys();
            while (iter2.hasNext()) {
                String childName = (String)iter2.next();
                JSONObject child = children.getJSONObject(childName);
                this.addNode(newNode, childName, child);
            }
        }
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Value decodeValue(String encodedValue, ValueFactory valueFactory) throws RepositoryException {
        byte[] binaryValue = Base64.decode((String)encodedValue);
        ByteArrayInputStream stream = new ByteArrayInputStream(binaryValue);
        try {
            Value value = valueFactory.createValue((InputStream)stream);
            return value;
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
    }

    private void setPropertyOnNode(Node node, String propName, Object value) throws RepositoryException, JSONException {
        Value[] values;
        boolean encoded = propName.endsWith(BASE64_ENCODING_SUFFIX);
        if (encoded) {
            int newLength = propName.length() - BASE64_ENCODING_SUFFIX.length();
            propName = newLength > 0 ? propName.substring(0, newLength) : "";
        }
        ValueFactory valueFactory = node.getSession().getValueFactory();
        if (value instanceof JSONArray) {
            JSONArray jsonValues = (JSONArray)value;
            values = new Value[jsonValues.length()];
            for (int i = 0; i < values.length; ++i) {
                String strValue = jsonValues.getString(i);
                values[i] = encoded ? this.decodeValue(strValue, valueFactory) : valueFactory.createValue(strValue);
            }
        } else {
            String strValue = (String)value;
            values = encoded ? new Value[]{this.decodeValue(strValue, valueFactory)} : new Value[]{valueFactory.createValue(strValue)};
        }
        if (propName.equals(MIXIN_TYPES_PROPERTY)) {
            HashSet<String> toBeMixins = new HashSet<String>();
            for (Value theValue : values) {
                toBeMixins.add(theValue.getString());
            }
            HashSet<String> asIsMixins = new HashSet<String>();
            for (NodeType nodeType : node.getMixinNodeTypes()) {
                asIsMixins.add(nodeType.getName());
            }
            HashSet mixinsToAdd = new HashSet(toBeMixins);
            mixinsToAdd.removeAll(asIsMixins);
            asIsMixins.removeAll(toBeMixins);
            for (String nodeType : mixinsToAdd) {
                node.addMixin(nodeType);
            }
            for (String nodeType : asIsMixins) {
                node.removeMixin(nodeType);
            }
        } else if (values.length == 1) {
            node.setProperty(propName, values[0]);
        } else {
            node.setProperty(propName, values);
        }
    }

    @DELETE
    @Path(value="/{repositoryName}/{workspaceName}/items{path:.*}")
    @Consumes(value={"application/json"})
    public void deleteItem(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="path") String path) throws NotFoundException, UnauthorizedException, RepositoryException {
        Item item;
        assert (rawRepositoryName != null);
        assert (rawWorkspaceName != null);
        assert (path != null);
        Session session = this.getSession(request, rawRepositoryName, rawWorkspaceName);
        try {
            item = session.getItem(path);
        }
        catch (PathNotFoundException pnfe) {
            throw new NotFoundException(pnfe.getMessage(), (Throwable)pnfe);
        }
        item.remove();
        session.save();
    }

    @PUT
    @Path(value="/{repositoryName}/{workspaceName}/items{path:.*}")
    @Consumes(value={"application/json"})
    public String putItem(@Context HttpServletRequest request, @PathParam(value="repositoryName") String rawRepositoryName, @PathParam(value="workspaceName") String rawWorkspaceName, @PathParam(value="path") String path, String requestContent) throws UnauthorizedException, JSONException, RepositoryException, IOException {
        Node node;
        Node item;
        assert (path != null);
        assert (rawRepositoryName != null);
        assert (rawWorkspaceName != null);
        Session session = this.getSession(request, rawRepositoryName, rawWorkspaceName);
        if ("".equals(path) || "/".equals(path)) {
            item = session.getRootNode();
        } else {
            try {
                item = session.getItem(path);
            }
            catch (PathNotFoundException pnfe) {
                throw new NotFoundException(pnfe.getMessage(), (Throwable)pnfe);
            }
        }
        if (item instanceof Node) {
            JSONObject properties = new JSONObject(requestContent);
            node = item;
            Iterator iter = properties.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                this.setPropertyOnNode(node, key, properties.get(key));
            }
        } else {
            JSONObject jsonProperty = new JSONObject(requestContent);
            Property property = (Property)item;
            String propertyName = property.getName();
            String jsonPropertyName = jsonProperty.has(propertyName) ? propertyName : propertyName + BASE64_ENCODING_SUFFIX;
            node = property.getParent();
            this.setPropertyOnNode(node, jsonPropertyName, jsonProperty.get(jsonPropertyName));
        }
        node.save();
        return this.jsonFor(node, 0).toString();
    }
}

