/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import javax.jcr.RepositoryException;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import net.jcip.annotations.Immutable;
import org.codehaus.jettison.json.JSONException;
import org.jboss.resteasy.spi.NotFoundException;
import org.modeshape.web.jcr.rest.AbstractJcrResource;
import org.modeshape.web.jcr.spi.NoSuchRepositoryException;

@Immutable
@Path(value="/")
public class JcrResources
extends AbstractJcrResource {

    @Provider
    public static class RepositoryExceptionMapper
    implements ExceptionMapper<RepositoryException> {
        public Response toResponse(RepositoryException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
    }

    @Provider
    public static class JSONExceptionMapper
    implements ExceptionMapper<JSONException> {
        public Response toResponse(JSONException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
    }

    @Provider
    public static class NoSuchRepositoryExceptionMapper
    implements ExceptionMapper<NoSuchRepositoryException> {
        public Response toResponse(NoSuchRepositoryException exception) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)exception.getMessage()).build();
        }
    }

    @Provider
    public static class NotFoundExceptionMapper
    implements ExceptionMapper<NotFoundException> {
        public Response toResponse(NotFoundException exception) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)exception.getMessage()).build();
        }
    }
}

