/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import java.util.LinkedList;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.servlet.http.HttpServletRequest;
import net.jcip.annotations.Immutable;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.web.jcr.rest.AbstractHandler;

@Immutable
public class QueryHandler
extends AbstractHandler {
    public String postItem(HttpServletRequest request, String rawRepositoryName, String rawWorkspaceName, String language, String statement, long offset, long limit) throws RepositoryException, JSONException {
        assert (rawRepositoryName != null);
        assert (rawWorkspaceName != null);
        assert (language != null);
        assert (statement != null);
        Session session = this.getSession(request, rawRepositoryName, rawWorkspaceName);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(statement, language);
        QueryResult result = query.execute();
        String[] columnNames = result.getColumnNames();
        LinkedList<JSONObject> jsonRows = new LinkedList<JSONObject>();
        RowIterator resultRows = result.getRows();
        if (offset > 0L) {
            resultRows.skip(offset);
        }
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        while (resultRows.hasNext() && limit > 0L) {
            --limit;
            Row resultRow = resultRows.nextRow();
            JSONObject jsonRow = new JSONObject();
            for (String columnName : columnNames) {
                Value value = resultRow.getValue(columnName);
                if (value.getType() == 2) {
                    jsonRow.put(columnName + "/base64/", (Object)this.jsonEncodedStringFor(value));
                    continue;
                }
                jsonRow.put(columnName, (Object)value.getString());
            }
            jsonRows.add(jsonRow);
        }
        JSONObject results = new JSONObject();
        if (result instanceof org.modeshape.jcr.api.query.QueryResult) {
            org.modeshape.jcr.api.query.QueryResult modeShapeResult = (org.modeshape.jcr.api.query.QueryResult)result;
            JSONObject columnTypeMap = new JSONObject();
            String[] columnTypes = modeShapeResult.getColumnTypes();
            assert (columnTypes.length == columnNames.length);
            for (int i = 0; i < columnNames.length; ++i) {
                columnTypeMap.put(columnNames[i], (Object)columnTypes[i]);
            }
            results.put("types", (Object)columnTypeMap);
        }
        results.put("rows", (Object)new JSONArray(jsonRows));
        return results.toString();
    }
}

