/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.web.jcr.rest.RestHelper;
import org.modeshape.web.jcr.rest.model.JSONAble;
import org.modeshape.web.jcr.rest.model.RestPropertyType;

public final class RestNodeType
implements JSONAble {
    private final Set<String> superTypesLinks;
    private final Set<String> subTypesLinks;
    private final List<RestPropertyType> propertyTypes;
    private final String name;
    private final boolean isMixin;
    private final boolean hasOrderableChildNodes;
    private final boolean isAbstract;
    private final boolean isQueryable;

    public RestNodeType(NodeType nodeType, String baseUrl) {
        this.name = nodeType.getName();
        this.isMixin = nodeType.isMixin();
        this.isAbstract = nodeType.isAbstract();
        this.isQueryable = nodeType.isQueryable();
        this.hasOrderableChildNodes = nodeType.hasOrderableChildNodes();
        this.superTypesLinks = new TreeSet<String>();
        for (NodeType nodeType2 : nodeType.getDeclaredSupertypes()) {
            String superTypeLink = RestHelper.urlFrom(baseUrl, "nodetypes", nodeType2.getName());
            this.superTypesLinks.add(superTypeLink);
        }
        this.subTypesLinks = new TreeSet<String>();
        NodeTypeIterator subTypeIterator = nodeType.getDeclaredSubtypes();
        while (subTypeIterator.hasNext()) {
            String subTypeLink = RestHelper.urlFrom(baseUrl, "nodetypes", subTypeIterator.nextNodeType().getName());
            this.subTypesLinks.add(subTypeLink);
        }
        this.propertyTypes = new ArrayList<RestPropertyType>();
        for (NodeType nodeType3 : nodeType.getDeclaredPropertyDefinitions()) {
            this.propertyTypes.add(new RestPropertyType((PropertyDefinition)nodeType3));
        }
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject content = new JSONObject();
        content.put("mixin", this.isMixin);
        content.put("abstract", this.isAbstract);
        content.put("queryable", this.isQueryable);
        content.put("hasOrderableChildNodes", this.hasOrderableChildNodes);
        if (!this.propertyTypes.isEmpty()) {
            for (RestPropertyType restPropertyType : this.propertyTypes) {
                content.accumulate("propertyDefinitions", (Object)restPropertyType.toJSON());
            }
        }
        if (!this.superTypesLinks.isEmpty()) {
            content.put("superTypes", this.superTypesLinks);
        }
        if (!this.subTypesLinks.isEmpty()) {
            content.put("subTypes", this.subTypesLinks);
        }
        JSONObject result = new JSONObject();
        result.put(this.name, (Object)content);
        return result;
    }
}

