/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.handler;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.api.query.QueryResult;
import org.modeshape.web.jcr.rest.RestHelper;
import org.modeshape.web.jcr.rest.handler.AbstractHandler;

@Immutable
@Deprecated
public class QueryHandler
extends AbstractHandler {
    protected static final List<String> SKIP_QUERY_PARAMETERS = Arrays.asList("offset", "limit");

    @Deprecated
    public String postItem(HttpServletRequest request, String rawRepositoryName, String rawWorkspaceName, String language, String statement, long offset, long limit, UriInfo uriInfo) throws RepositoryException, JSONException {
        assert (rawRepositoryName != null);
        assert (rawWorkspaceName != null);
        assert (language != null);
        assert (statement != null);
        Session session = this.getSession(request, rawRepositoryName, rawWorkspaceName);
        Query query = this.createQuery(language, statement, session);
        this.bindExtraVariables(uriInfo, session.getValueFactory(), query);
        javax.jcr.query.QueryResult result = query.execute();
        String[] columnNames = result.getColumnNames();
        LinkedList<JSONObject> jsonRows = new LinkedList<JSONObject>();
        RowIterator resultRows = result.getRows();
        if (offset > 0L) {
            resultRows.skip(offset);
        }
        if (limit < 0L) {
            limit = Long.MAX_VALUE;
        }
        while (resultRows.hasNext() && limit > 0L) {
            --limit;
            Row resultRow = resultRows.nextRow();
            JSONObject jsonRow = new JSONObject();
            for (String columnName : columnNames) {
                Value value = resultRow.getValue(columnName);
                if (value == null) continue;
                if (value.getType() == 2) {
                    jsonRow.put(columnName + "/base64/", (Object)RestHelper.jsonEncodedStringFor(value));
                    continue;
                }
                jsonRow.put(columnName, (Object)value.getString());
            }
            jsonRows.add(jsonRow);
        }
        JSONObject results = new JSONObject();
        if (result instanceof QueryResult) {
            QueryResult modeShapeResult = (QueryResult)result;
            JSONObject columnTypeMap = new JSONObject();
            String[] columnTypes = modeShapeResult.getColumnTypes();
            assert (columnTypes.length == columnNames.length);
            for (int i = 0; i < columnNames.length; ++i) {
                columnTypeMap.put(columnNames[i], (Object)columnTypes[i]);
            }
            results.put("types", (Object)columnTypeMap);
        }
        results.put("rows", (Object)new JSONArray(jsonRows));
        return RestHelper.responseString(results, request);
    }

    protected Query createQuery(String language, String statement, Session session) throws RepositoryException {
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        return queryManager.createQuery(statement, language);
    }

    protected void bindExtraVariables(UriInfo uriInfo, ValueFactory valueFactory, Query query) throws RepositoryException {
        if (uriInfo == null) {
            return;
        }
        for (Map.Entry entry : uriInfo.getQueryParameters().entrySet()) {
            String variableName = (String)entry.getKey();
            List variableValues = (List)entry.getValue();
            if (variableValues == null || variableValues.isEmpty() || SKIP_QUERY_PARAMETERS.contains(variableName)) continue;
            Iterator valuesIterator = variableValues.iterator();
            String variableValue = null;
            while (valuesIterator.hasNext() && variableValue == null) {
                variableValue = (String)valuesIterator.next();
            }
            if (variableValue == null) continue;
            query.bindValue(variableName, valueFactory.createValue(variableValue));
        }
    }
}

