/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.util.StringUtil;
import org.modeshape.web.jcr.rest.model.JSONAble;

public final class RestQueryResult
implements JSONAble {
    private final Map<String, String> columns = new LinkedHashMap<String, String>();
    private final List<RestRow> rows = new ArrayList<RestRow>();

    public RestQueryResult addColumn(String name, String type) {
        if (!StringUtil.isBlank((String)name)) {
            this.columns.put(name, type);
        }
        return this;
    }

    public RestQueryResult addRow(RestRow row) {
        this.rows.add(row);
        return this;
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        JSONObject result = new JSONObject();
        if (!this.columns.isEmpty()) {
            result.put("columns", this.columns);
        }
        if (!this.rows.isEmpty()) {
            JSONArray rows = new JSONArray();
            for (RestRow row : this.rows) {
                rows.put((Object)row.toJSON());
            }
            result.put("rows", (Object)rows);
        }
        return result;
    }

    public class RestRow
    implements JSONAble {
        private final Map<String, Object> values = new LinkedHashMap<String, Object>();

        public void addValue(String name, Object value) {
            if (value == null || StringUtil.isBlank((String)name)) {
                return;
            }
            if (value instanceof Collection) {
                this.values.put(name, value);
            } else {
                String valueString = value.toString();
                if (!StringUtil.isBlank((String)valueString)) {
                    this.values.put(name, valueString);
                }
            }
        }

        @Override
        public JSONObject toJSON() {
            return new JSONObject(this.values);
        }
    }
}

