/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.spi;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.modeshape.jcr.api.RepositoryFactory;
import org.modeshape.jcr.api.ServletCredentials;
import org.modeshape.web.jcr.spi.NoSuchRepositoryException;
import org.modeshape.web.jcr.spi.RepositoryProvider;

public class FactoryRepositoryProvider
implements RepositoryProvider {
    public static final String JCR_URL = "org.modeshape.web.jcr.JCR_URL";
    private String jcrUrl;

    @Override
    public Set<String> getJcrRepositoryNames() {
        RepositoryFactory factory = this.factory();
        if (factory == null) {
            return null;
        }
        return factory.getRepositories(this.jcrUrl).getRepositoryNames();
    }

    private Repository getRepository(String repositoryName) throws RepositoryException {
        RepositoryFactory factory = this.factory();
        if (factory == null) {
            return null;
        }
        return factory.getRepositories(this.jcrUrl).getRepository(repositoryName);
    }

    @Override
    public void startup(ServletContext context) {
        this.jcrUrl = context.getInitParameter(JCR_URL);
    }

    @Override
    public void shutdown() {
        this.factory().shutdown();
    }

    private final RepositoryFactory factory() {
        Iterator<RepositoryFactory> i$ = ServiceLoader.load(RepositoryFactory.class).iterator();
        if (i$.hasNext()) {
            RepositoryFactory factory = i$.next();
            return factory;
        }
        throw new IllegalStateException("No RepositoryFactory implementation on the classpath");
    }

    @Override
    public Session getSession(HttpServletRequest request, String repositoryName, String workspaceName) throws RepositoryException {
        Repository repository;
        assert (request != null);
        try {
            repository = this.getRepository(repositoryName);
        }
        catch (RepositoryException re) {
            throw new NoSuchRepositoryException(re.getMessage(), re);
        }
        if (request.getUserPrincipal() == null) {
            return repository.login(workspaceName);
        }
        return repository.login((Credentials)new ServletCredentials(request), workspaceName);
    }
}

