/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.Logger;
import org.modeshape.jcr.api.RepositoriesContainer;
import org.modeshape.jcr.api.ServletCredentials;
import org.modeshape.web.jcr.NoSuchRepositoryException;
import org.modeshape.web.jcr.WebJcrI18n;
import org.modeshape.web.jcr.WebLogger;

@ThreadSafe
public class RepositoryManager {
    private static final Logger LOGGER = WebLogger.getLogger(RepositoryManager.class);
    private static final Map<String, Object> factoryParams = new HashMap<String, Object>();
    private static RepositoriesContainer repositoriesContainer;

    private RepositoryManager() {
    }

    static synchronized void initialize(ServletContext context) {
        CheckArg.isNotNull((Object)context, (String)"context");
        RepositoryManager.loadFactoryParameters(context);
        RepositoryManager.loadRepositoriesContainer();
    }

    private static void loadRepositoriesContainer() {
        Iterator<RepositoriesContainer> containersIterator = ServiceLoader.load(RepositoriesContainer.class).iterator();
        if (!containersIterator.hasNext()) {
            throw new IllegalStateException(WebJcrI18n.repositoriesContainerNotFoundInClasspath.text(new Object[]{RepositoriesContainer.class.getName()}));
        }
        repositoriesContainer = containersIterator.next();
    }

    private static void loadFactoryParameters(ServletContext context) {
        factoryParams.clear();
        Enumeration names = context.getInitParameterNames();
        if (names == null) {
            RepositoryManager.addParameter("org.modeshape.jcr.URL", context);
            RepositoryManager.addParameter("org.modeshape.jcr.RepositoryName", context);
        } else {
            while (names.hasMoreElements()) {
                Object next = names.nextElement();
                if (next == null) continue;
                String name = next.toString();
                RepositoryManager.addParameter(name, context);
            }
        }
    }

    private static void addParameter(String name, ServletContext context) {
        String value = context.getInitParameter(name);
        if (value != null) {
            factoryParams.put(name, value);
        }
    }

    public static Session getSession(HttpServletRequest request, String repositoryName, String workspaceName) throws RepositoryException {
        Repository repository = RepositoryManager.getRepository(repositoryName);
        if (request == null || request.getUserPrincipal() == null) {
            return repository.login(workspaceName);
        }
        return repository.login((Credentials)new ServletCredentials(request), workspaceName);
    }

    public static Repository getRepository(String repositoryName) throws NoSuchRepositoryException {
        Repository repository = null;
        try {
            repository = repositoriesContainer.getRepository(repositoryName, Collections.unmodifiableMap(factoryParams));
        }
        catch (RepositoryException e) {
            throw new NoSuchRepositoryException(WebJcrI18n.cannotInitializeRepository.text(new Object[]{repositoryName}), e);
        }
        if (repository == null) {
            throw new NoSuchRepositoryException(WebJcrI18n.repositoryNotFound.text(new Object[]{repositoryName}));
        }
        return repository;
    }

    public static Set<String> getJcrRepositoryNames() {
        try {
            return repositoriesContainer.getRepositoryNames(Collections.unmodifiableMap(factoryParams));
        }
        catch (RepositoryException e) {
            LOGGER.error((Throwable)e, WebJcrI18n.cannotLoadRepositoryNames.text(new Object[0]), new Object[0]);
            return Collections.emptySet();
        }
    }

    static void shutdown() {
        repositoriesContainer.shutdown();
    }
}

