/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.mavenplugin.generate;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.moditect.commands.GenerateModuleInfo;
import org.moditect.mavenplugin.common.model.ArtifactConfiguration;
import org.moditect.mavenplugin.common.model.ModuleInfoConfiguration;
import org.moditect.mavenplugin.generate.model.ArtifactIdentifier;
import org.moditect.mavenplugin.util.ArtifactResolutionHelper;
import org.moditect.mavenplugin.util.MojoLog;
import org.moditect.model.DependencePattern;
import org.moditect.model.DependencyDescriptor;
import org.moditect.model.GeneratedModuleInfo;
import org.moditect.model.PackageNamePattern;

public class ModuleInfoGenerator {
    private final MavenProject project;
    private final RepositorySystem repoSystem;
    private final RepositorySystemSession repoSession;
    private final List<RemoteRepository> remoteRepos;
    private final ArtifactResolutionHelper artifactResolutionHelper;
    private final List<String> jdepsExtraArgs;
    private final Log log;
    private final File workingDirectory;
    private final File outputDirectory;

    public ModuleInfoGenerator(MavenProject project, RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepos, ArtifactResolutionHelper artifactResolutionHelper, List<String> jdepsExtraArgs, Log log, File workingDirectory, File outputDirectory) {
        this.project = project;
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
        this.remoteRepos = remoteRepos;
        this.artifactResolutionHelper = artifactResolutionHelper;
        this.jdepsExtraArgs = jdepsExtraArgs;
        this.log = log;
        this.workingDirectory = workingDirectory;
        this.outputDirectory = outputDirectory;
    }

    public GeneratedModuleInfo generateModuleInfo(ArtifactConfiguration artifact, List<ArtifactConfiguration> additionalDependencies, ModuleInfoConfiguration moduleInfo, Map<ArtifactIdentifier, String> assignedNamesByModule, Map<ArtifactIdentifier, Path> modularizedJars) throws MojoExecutionException {
        this.log.debug((CharSequence)("Adding module descriptor to artifact " + artifact.toDependencyString()));
        Artifact inputArtifact = this.artifactResolutionHelper.resolveArtifact(artifact);
        Set<DependencyDescriptor> dependencies = this.getDependencies(inputArtifact, assignedNamesByModule, modularizedJars);
        for (ArtifactConfiguration further : additionalDependencies) {
            Artifact furtherArtifact = this.artifactResolutionHelper.resolveArtifact(further);
            Path modularized = this.getModularizedJar(modularizedJars, new ArtifactIdentifier(further.getGroupId(), further.getArtifactId(), further.getVersion(), further.getType(), further.getClassifier()));
            dependencies.add(new DependencyDescriptor(modularized != null ? modularized : furtherArtifact.getFile().toPath(), false, null));
        }
        return this.generateModuleInfo(inputArtifact.getFile().toPath(), dependencies, moduleInfo);
    }

    public GeneratedModuleInfo generateModuleInfo(Path inputJar, List<ArtifactConfiguration> additionalDependencies, ModuleInfoConfiguration moduleInfo, Map<ArtifactIdentifier, String> assignedNamesByModule) throws MojoExecutionException {
        HashSet<DependencyDescriptor> dependencies = new HashSet<DependencyDescriptor>();
        for (ArtifactConfiguration further : additionalDependencies) {
            Artifact furtherArtifact = this.artifactResolutionHelper.resolveArtifact(further);
            dependencies.add(new DependencyDescriptor(furtherArtifact.getFile().toPath(), false, null));
        }
        return this.generateModuleInfo(inputJar, dependencies, moduleInfo);
    }

    public GeneratedModuleInfo generateModuleInfo(Path inputJar, Set<DependencyDescriptor> dependencies, ModuleInfoConfiguration moduleInfo) throws MojoExecutionException {
        Set uses = moduleInfo.getUses() != null ? Arrays.stream(moduleInfo.getUses().split(";")).map(String::trim).collect(Collectors.toSet()) : Collections.emptySet();
        return new GenerateModuleInfo(inputJar, moduleInfo.getName(), moduleInfo.isOpen(), dependencies, PackageNamePattern.parsePatterns((String)moduleInfo.getExports()), PackageNamePattern.parsePatterns((String)moduleInfo.getOpens()), DependencePattern.parsePatterns((String)moduleInfo.getRequires()), this.workingDirectory.toPath(), this.outputDirectory.toPath(), uses, moduleInfo.isAddServiceUses(), this.jdepsExtraArgs, (org.moditect.spi.log.Log)new MojoLog(this.log)).run();
    }

    private Set<DependencyDescriptor> getDependencies(Artifact inputArtifact, Map<ArtifactIdentifier, String> assignedNamesByModule, Map<ArtifactIdentifier, Path> modularizedJars) throws MojoExecutionException {
        LinkedHashSet<DependencyDescriptor> dependencies = new LinkedHashSet<DependencyDescriptor>();
        for (DependencyNode dependency : this.artifactResolutionHelper.getCompilationDependencies(inputArtifact)) {
            Artifact artifact = dependency.getDependency().getArtifact();
            String versionFromProject = this.getVersionFromProject(artifact);
            if (versionFromProject != null) {
                artifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), versionFromProject);
            }
            Artifact resolvedDependency = this.artifactResolutionHelper.resolveArtifact(artifact);
            String assignedModuleName = this.getAssignedModuleName(assignedNamesByModule, new ArtifactIdentifier(resolvedDependency));
            Path modularized = this.getModularizedJar(modularizedJars, new ArtifactIdentifier(resolvedDependency));
            dependencies.add(new DependencyDescriptor(modularized != null ? modularized : resolvedDependency.getFile().toPath(), dependency.getDependency().isOptional(), assignedModuleName));
        }
        return dependencies;
    }

    private String getAssignedModuleName(Map<ArtifactIdentifier, String> assignedNamesByModule, ArtifactIdentifier artifactIdentifier) {
        for (Map.Entry<ArtifactIdentifier, String> assignedNameByModule : assignedNamesByModule.entrySet()) {
            if (!assignedNameByModule.getKey().getGroupId().equals(artifactIdentifier.getGroupId()) || !assignedNameByModule.getKey().getArtifactId().equals(artifactIdentifier.getArtifactId()) || !assignedNameByModule.getKey().getClassifier().equals(artifactIdentifier.getClassifier()) || !assignedNameByModule.getKey().getExtension().equals(artifactIdentifier.getExtension())) continue;
            return assignedNameByModule.getValue();
        }
        return null;
    }

    private Path getModularizedJar(Map<ArtifactIdentifier, Path> modularizedJars, ArtifactIdentifier artifactIdentifier) {
        for (Map.Entry<ArtifactIdentifier, Path> assignedNameByModule : modularizedJars.entrySet()) {
            if (!assignedNameByModule.getKey().getGroupId().equals(artifactIdentifier.getGroupId()) || !assignedNameByModule.getKey().getArtifactId().equals(artifactIdentifier.getArtifactId()) || !this.areEqualClassifiers(assignedNameByModule.getKey().getClassifier(), artifactIdentifier.getClassifier()) || !assignedNameByModule.getKey().getExtension().equals(artifactIdentifier.getExtension())) continue;
            return assignedNameByModule.getValue();
        }
        return null;
    }

    private String getVersionFromProject(Artifact artifact) throws MojoExecutionException {
        Optional<Dependency> managed;
        Optional<org.apache.maven.artifact.Artifact> resolvedDependency = this.project.getArtifacts().stream().filter(a -> Objects.equals(a.getGroupId(), artifact.getGroupId()) && Objects.equals(a.getArtifactId(), artifact.getArtifactId()) && this.areEqualClassifiers(a.getClassifier(), artifact.getClassifier()) && Objects.equals(a.getType(), artifact.getExtension())).findFirst();
        if (resolvedDependency.isPresent()) {
            return resolvedDependency.get().getVersion();
        }
        if (this.project.getDependencyManagement() != null && (managed = this.project.getDependencyManagement().getDependencies().stream().filter(d -> Objects.equals(d.getGroupId(), artifact.getGroupId()) && Objects.equals(d.getArtifactId(), artifact.getArtifactId()) && this.areEqualClassifiers(d.getClassifier(), artifact.getClassifier()) && Objects.equals(d.getType(), artifact.getExtension())).findFirst()).isPresent()) {
            return managed.get().getVersion();
        }
        return null;
    }

    private boolean areEqualClassifiers(String classifier1, String classifier2) {
        if (classifier1 != null && classifier1.isEmpty()) {
            classifier1 = null;
        }
        if (classifier2 != null && classifier2.isEmpty()) {
            classifier2 = null;
        }
        return Objects.equals(classifier1, classifier2);
    }
}

