/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.mavenplugin.util;

import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.moditect.mavenplugin.common.model.ArtifactConfiguration;
import org.moditect.mavenplugin.generate.CompileScopeDependencySelector;

public class ArtifactResolutionHelper {
    private RepositorySystem repoSystem;
    private RepositorySystemSession repoSession;
    private List<RemoteRepository> remoteRepos;

    public ArtifactResolutionHelper(RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepos) {
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
        this.remoteRepos = remoteRepos;
    }

    public Artifact resolveArtifact(ArtifactConfiguration artifact) throws MojoExecutionException {
        return this.resolveArtifact((Artifact)new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType() != null ? artifact.getType() : "jar", artifact.getVersion()));
    }

    public Artifact resolveArtifact(Artifact inputArtifact) throws MojoExecutionException {
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact(inputArtifact);
        request.setRepositories(this.remoteRepos);
        try {
            return this.repoSystem.resolveArtifact(this.repoSession, request).getArtifact();
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public List<DependencyNode> getCompilationDependencies(Artifact inputArtifact) throws MojoExecutionException {
        try {
            CollectRequest collectRequest = new CollectRequest(new Dependency(inputArtifact, "compile"), this.remoteRepos);
            DefaultRepositorySystemSession sessionWithProvided = MavenRepositorySystemUtils.newSession();
            sessionWithProvided.setDependencySelector((DependencySelector)new AndDependencySelector(new DependencySelector[]{new CompileScopeDependencySelector(), new OptionalDependencySelector(), new ExclusionDependencySelector()}));
            sessionWithProvided.setLocalRepositoryManager(this.repoSession.getLocalRepositoryManager());
            CollectResult collectResult = this.repoSystem.collectDependencies((RepositorySystemSession)sessionWithProvided, collectRequest);
            PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
            collectResult.getRoot().accept((DependencyVisitor)nlg);
            List dependencies = nlg.getNodes();
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                DependencyNode next = (DependencyNode)it.next();
                if (next.getDependency() != collectRequest.getRoot()) continue;
                it.remove();
            }
            return dependencies;
        }
        catch (DependencyCollectionException e) {
            throw new MojoExecutionException("Couldn't collect dependencies of artifact " + inputArtifact, (Exception)((Object)e));
        }
    }
}

