/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.mavenplugin.modulelist;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.moditect.commands.GenerateModuleList;
import org.moditect.mavenplugin.util.DependencyHelper;
import org.moditect.mavenplugin.util.MojoLog;
import org.moditect.model.Version;
import org.moditect.spi.log.Log;

@Mojo(name="list-application-image-modules", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class GenerateModuleListMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="moditect.jvmVersion")
    private Integer jvmVersion;

    public void execute() throws MojoExecutionException {
        GenerateModuleList generateModuleList = new GenerateModuleList(new File(this.project.getBuild().getOutputDirectory()).toPath(), DependencyHelper.getDirectAndTransitiveDependencies(this.project), this.determineJvmVersion(), (Log)new MojoLog(this.getLog()));
        try {
            generateModuleList.run();
        }
        catch (RuntimeException ex) {
            this.getLog().error((Throwable)ex);
            throw new MojoExecutionException("Error generating module list", (Exception)ex);
        }
    }

    private Version determineJvmVersion() {
        if (this.jvmVersion != null) {
            return Version.valueOf((Object)this.jvmVersion);
        }
        Object rawVersion = this.project.getProperties().get("maven.compiler.release");
        if (rawVersion != null) {
            return Version.valueOf((Object)rawVersion);
        }
        rawVersion = this.project.getProperties().get("maven.compiler.target");
        if (rawVersion != null) {
            return Version.valueOf((Object)rawVersion);
        }
        throw new IllegalStateException("Couldn't determine target version, please specify the 'targetVersion' configuration property");
    }
}

