/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.docs;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaModifier;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.moduliths.model.FormatableJavaClass;
import org.moduliths.model.Module;
import org.moduliths.model.SpringBean;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

class Asciidoctor {
    private final String javaDocBase;
    @Nullable
    private final Module module;

    public static Asciidoctor withoutJavadocBase(@Nullable Module module) {
        return new Asciidoctor("\u00af\\_(\u30c4)_/\u00af", module);
    }

    public String toInlineCode(String source) {
        return String.format("`%s`", source);
    }

    public String toInlineCode(JavaClass type) {
        return this.toOptionalLink(type);
    }

    public String toInlineCode(SpringBean bean) {
        String base = this.toInlineCode(bean.getType());
        List interfaces = bean.getInterfacesWithinModule();
        if (interfaces.isEmpty()) {
            return base;
        }
        String interfacesAsString = interfaces.stream().map(this::toInlineCode).collect(Collectors.joining(", "));
        return String.format("%s implementing %s", base, interfacesAsString);
    }

    public String beansToBulletPoints(List<SpringBean> beans) {
        return this.toBulletPoints(beans.stream().map(this::toInlineCode));
    }

    public String typesToBulletPoints(List<JavaClass> types) {
        return this.toBulletPoints(types.stream().map(this::toOptionalLink));
    }

    private String toBulletPoints(Stream<String> types) {
        return types.collect(Collectors.joining("\n* ", "* ", ""));
    }

    public String toBulletPoint(String source) {
        return String.format("* %s", source);
    }

    private String toOptionalLink(JavaClass source) {
        String type = Asciidoctor.toCode(FormatableJavaClass.of((JavaClass)source).getAbbreviatedFullName(this.module));
        if (!source.getModifiers().contains(JavaModifier.PUBLIC)) {
            return type;
        }
        String classPath = ClassUtils.convertClassNameToResourcePath((String)source.getFullName()).replace('$', '.');
        return Optional.ofNullable(this.javaDocBase == "\u00af\\_(\u30c4)_/\u00af" ? null : this.javaDocBase).map(it -> it.concat("/").concat(classPath).concat(".html")).map(it -> Asciidoctor.toLink(type, it)).orElse(type);
    }

    private static String toLink(String source, String href) {
        return String.format("link:%s[%s]", href, source);
    }

    private static String toCode(String source) {
        return String.format("`%s`", source);
    }

    public static String startTable(String tableSpec) {
        return String.format("[%s]\n|===\n", tableSpec);
    }

    public static String startOrEndTable() {
        return "|===\n";
    }

    public static String writeTableRow(String ... columns) {
        return Stream.of(columns).collect(Collectors.joining("\n|", "|", "\n"));
    }

    private Asciidoctor(String javaDocBase, @Nullable Module module) {
        this.javaDocBase = javaDocBase;
        this.module = module;
    }

    public static Asciidoctor withJavadocBase(String javaDocBase, @Nullable Module module) {
        return new Asciidoctor(javaDocBase, module);
    }
}

