/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.docs;

import com.tngtech.archunit.core.domain.JavaMethod;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.moduliths.docs.DocumentationSource;
import org.moduliths.docs.InlineCodeSource;

class CodeReplacingDocumentationSource
implements DocumentationSource {
    private static final Pattern JAVADOC_CODE = Pattern.compile("\\{\\@(?>link|code)\\s(.*)\\}");
    private final DocumentationSource delegate;
    private final InlineCodeSource codeSource;

    @Override
    public Optional<String> getDocumentation(JavaMethod method) {
        return this.delegate.getDocumentation(method).map(this::replaceJavadocCodeReferences);
    }

    private String replaceJavadocCodeReferences(String source) {
        Matcher matcher = JAVADOC_CODE.matcher(source);
        while (matcher.find()) {
            String type = matcher.group(1);
            source = source.replace(matcher.group(), this.codeSource.toInlineCode(type));
        }
        return source;
    }

    @Generated
    public CodeReplacingDocumentationSource(DocumentationSource delegate, InlineCodeSource codeSource) {
        this.delegate = delegate;
        this.codeSource = codeSource;
    }
}

