/*
 * Decompiled with CFR 0.152.
 */
package org.moduliths.docs;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.tngtech.archunit.core.domain.JavaType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.moduliths.model.Module;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ConfigurationProperties
implements Iterable<ConfigurationProperty> {
    private static final String METADATA_PATH = "classpath:META-INF/spring-configuration-metadata.json";
    private static final JsonPath PATH = JsonPath.compile((String)"$.properties", (Predicate[])new Predicate[0]);
    private final List<ConfigurationProperty> properties;

    ConfigurationProperties() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = resolver.getResources(METADATA_PATH);
            this.properties = Arrays.stream(resources).flatMap(ConfigurationProperties::parseProperties).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ModuleProperty> getModuleProperties(Module module) {
        Assert.notNull((Object)module, (String)"Module must not be null!");
        return this.properties.stream().flatMap(it -> this.getModuleProperty(module, (ConfigurationProperty)it)).collect(Collectors.toList());
    }

    @Override
    public Iterator<ConfigurationProperty> iterator() {
        return this.properties.iterator();
    }

    private Stream<ModuleProperty> getModuleProperty(Module module, ConfigurationProperty property) {
        return module.getType(property.getSourceType()).map(it -> new ModuleProperty(property.getName(), property.getDescription(), property.getType(), (JavaType)it, property.getDefaultValue())).map(Stream::of).orElseGet(Stream::empty);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Stream<ConfigurationProperty> parseProperties(Resource source) {
        if (!source.exists()) {
            return Stream.empty();
        }
        try (InputStream stream2 = source.getInputStream();){
            DocumentContext context = JsonPath.parse((InputStream)stream2);
            List read = (List)context.read(PATH, List.class);
            Stream<ConfigurationProperty> stream = read.stream().map(it -> (Map)it).flatMap(ConfigurationProperty::of);
            return stream;
        }
        catch (Exception o_O) {
            return Stream.empty();
        }
    }

    static final class ModuleProperty {
        private final String name;
        @Nullable
        private final String description;
        private final String type;
        private final JavaType sourceType;
        @Nullable
        private final String defaultValue;

        @Generated
        public ModuleProperty(String name, @Nullable String description, String type, JavaType sourceType, @Nullable String defaultValue) {
            this.name = name;
            this.description = description;
            this.type = type;
            this.sourceType = sourceType;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Nullable
        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public JavaType getSourceType() {
            return this.sourceType;
        }

        @Nullable
        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModuleProperty)) {
                return false;
            }
            ModuleProperty other = (ModuleProperty)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            JavaType this$sourceType = this.getSourceType();
            JavaType other$sourceType = other.getSourceType();
            if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
                return false;
            }
            String this$defaultValue = this.getDefaultValue();
            String other$defaultValue = other.getDefaultValue();
            return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            JavaType $sourceType = this.getSourceType();
            result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
            String $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ConfigurationProperties.ModuleProperty(name=" + this.getName() + ", description=" + this.getDescription() + ", type=" + this.getType() + ", sourceType=" + this.getSourceType() + ", defaultValue=" + this.getDefaultValue() + ")";
        }
    }

    static final class ConfigurationProperty {
        private final String name;
        @Nullable
        private final String description;
        private final String type;
        private final String sourceType;
        @Nullable
        private final String defaultValue;

        static Stream<ConfigurationProperty> of(Map<String, Object> source) {
            String sourceType = ConfigurationProperty.getAsString(source, "sourceType");
            if (!StringUtils.hasText((String)sourceType)) {
                return Stream.empty();
            }
            ConfigurationProperty property = new ConfigurationProperty(ConfigurationProperty.getAsString(source, "name"), ConfigurationProperty.getAsString(source, "description"), ConfigurationProperty.getAsString(source, "type"), sourceType, ConfigurationProperty.getAsString(source, "defaultValue"));
            return Stream.of(property);
        }

        boolean hasSourceType() {
            return StringUtils.hasText((String)this.sourceType);
        }

        @Nullable
        private static String getAsString(Map<String, Object> source, String key) {
            Object value = source.get(key);
            return value == null ? null : value.toString();
        }

        @Generated
        public ConfigurationProperty(String name, @Nullable String description, String type, String sourceType, @Nullable String defaultValue) {
            this.name = name;
            this.description = description;
            this.type = type;
            this.sourceType = sourceType;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Nullable
        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getSourceType() {
            return this.sourceType;
        }

        @Nullable
        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigurationProperty)) {
                return false;
            }
            ConfigurationProperty other = (ConfigurationProperty)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$sourceType = this.getSourceType();
            String other$sourceType = other.getSourceType();
            if (this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType)) {
                return false;
            }
            String this$defaultValue = this.getDefaultValue();
            String other$defaultValue = other.getDefaultValue();
            return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $sourceType = this.getSourceType();
            result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
            String $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ConfigurationProperties.ConfigurationProperty(name=" + this.getName() + ", description=" + this.getDescription() + ", type=" + this.getType() + ", sourceType=" + this.getSourceType() + ", defaultValue=" + this.getDefaultValue() + ")";
        }
    }
}

