/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib;

import java.net.URI;
import java.net.URISyntaxException;
import org.moera.lib.naming.NodeName;

public class UniversalLocation {
    public static final String REDIRECTOR = "moera.page";
    private String nodeName;
    private String scheme;
    private String authority;
    private String path;
    private String query;
    private String fragment;

    public UniversalLocation(URI uri) {
        int i;
        String path = uri.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.isEmpty()) {
            return;
        }
        String[] dirs = path.split("/");
        if (!dirs[0].startsWith("@")) {
            return;
        }
        if (dirs[0].length() > 1) {
            this.nodeName = dirs[0].substring(1);
        }
        String host = null;
        String port = null;
        if (dirs.length > 1 && !dirs[1].equals("~")) {
            String[] parts = dirs[1].split(":");
            if (parts[i = 0].indexOf(46) < 0) {
                this.scheme = parts[i++];
            }
            if (i < parts.length) {
                host = parts[i++];
            }
            if (i < parts.length) {
                port = parts[i++];
            }
        }
        if (this.scheme == null) {
            this.scheme = "https";
        }
        if (host != null && !host.isEmpty()) {
            this.authority = host;
            if (port != null && !port.isEmpty()) {
                this.authority = this.authority + ":" + port;
            }
        }
        StringBuilder buf = new StringBuilder();
        for (i = 2; i < dirs.length; ++i) {
            buf.append('/').append(dirs[i]);
        }
        this.path = buf.isEmpty() ? "/" : buf.toString();
        this.query = uri.getQuery();
        this.fragment = uri.getFragment();
    }

    public UniversalLocation(String nodeName, String scheme, String authority, String path, String query, String fragment) {
        this.setNodeName(nodeName);
        this.setScheme(scheme);
        this.setAuthority(authority);
        this.setPath(path);
        this.setQuery(query);
        this.setFragment(fragment);
    }

    public static String redirectTo(String nodeName, String url) {
        try {
            UniversalLocation uni;
            URI uri;
            if (url != null) {
                uri = new URI(url);
                uni = new UniversalLocation(nodeName, uri.getScheme(), uri.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment());
            } else {
                uni = new UniversalLocation(nodeName, null, null, null, null, null);
            }
            uri = new URI("https", REDIRECTOR, uni.getLocation(), uni.getQuery(), uni.getFragment());
            return uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            return "https://moera.page";
        }
    }

    public static String redirectTo(String nodeName, String rootUrl, String path, String query, String fragment) {
        try {
            UniversalLocation uni;
            URI uri;
            if (rootUrl != null) {
                uri = new URI(rootUrl);
                uni = new UniversalLocation(nodeName, uri.getScheme(), uri.getAuthority(), path, query, fragment);
            } else {
                uni = new UniversalLocation(nodeName, null, null, path, query, fragment);
            }
            uri = new URI("https", REDIRECTOR, uni.getLocation(), uni.getQuery(), uni.getFragment());
            return uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            return "https://moera.page";
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = NodeName.shorten(nodeName);
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        if (scheme == null) {
            scheme = "https";
        }
        this.scheme = scheme;
    }

    public String getAuthority() {
        return this.authority;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public void setSchemeAndAuthority(URI uri) {
        this.setScheme(uri.getScheme());
        this.setAuthority(uri.getAuthority());
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (path != null && path.startsWith("/moera")) {
            path = path.substring(6);
        }
        this.path = path != null && !path.isEmpty() ? path : "/";
    }

    public String getLocation() {
        StringBuilder buf = new StringBuilder();
        buf.append("/@");
        if (this.nodeName != null) {
            buf.append(this.nodeName);
        }
        buf.append('/');
        if (this.authority != null) {
            if (this.scheme != null && !this.scheme.equalsIgnoreCase("https")) {
                buf.append(this.scheme).append(':');
            }
            buf.append(this.authority);
        } else {
            buf.append('~');
        }
        buf.append(this.path);
        return buf.toString();
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public void setFragment(String fragment) {
        this.fragment = fragment;
    }
}

