/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum SubscriptionType {
    FEED,
    POSTING,
    POSTING_COMMENTS,
    PROFILE,
    USER_LIST;


    @JsonValue
    public String getValue() {
        return this.name().toLowerCase().replace("__", "/").replace('_', '-');
    }

    public static String toValue(SubscriptionType type) {
        return type != null ? type.getValue() : null;
    }

    public static SubscriptionType forValue(String value) {
        try {
            return SubscriptionType.parse(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static SubscriptionType parse(String value) {
        return SubscriptionType.valueOf(value.toUpperCase().replace('-', '_').replace("/", "__"));
    }
}

