/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.moera.lib.node.types.BlockedOperation;
import org.moera.lib.node.types.notifications.Notification;
import org.moera.lib.node.types.notifications.NotificationType;
import org.moera.lib.node.types.validate.ValidationUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BlockingDeletedNotification
extends Notification {
    private BlockedOperation blockedOperation;
    private String postingId;
    private String postingHeading;

    public BlockingDeletedNotification() {
        super(NotificationType.BLOCKING_DELETED);
    }

    public BlockedOperation getBlockedOperation() {
        return this.blockedOperation;
    }

    public void setBlockedOperation(BlockedOperation blockedOperation) {
        this.blockedOperation = blockedOperation;
    }

    public String getPostingId() {
        return this.postingId;
    }

    public void setPostingId(String postingId) {
        this.postingId = postingId;
    }

    public String getPostingHeading() {
        return this.postingHeading;
    }

    public void setPostingHeading(String postingHeading) {
        this.postingHeading = postingHeading;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.maxSize(this.postingId, 40, "blocking.posting-id.wrong-size");
        ValidationUtil.maxSize(this.postingHeading, 255, "blocking.posting-heading.wrong-size");
    }
}

