/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum DraftType {
    NEW_POSTING,
    POSTING_UPDATE,
    NEW_COMMENT,
    COMMENT_UPDATE;


    @JsonValue
    public String getValue() {
        return this.name().toLowerCase().replace("__", "/").replace('_', '-');
    }

    public static String toValue(DraftType type) {
        return type != null ? type.getValue() : null;
    }

    public static DraftType forValue(String value) {
        try {
            return DraftType.parse(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static DraftType parse(String value) {
        return DraftType.valueOf(value.toUpperCase().replace('-', '_').replace("/", "__"));
    }
}

