/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum SubscriptionReason {
    USER,
    MENTION,
    COMMENT,
    AUTO;


    @JsonValue
    public String getValue() {
        return this.name().toLowerCase().replace("__", "/").replace('_', '-');
    }

    public static String toValue(SubscriptionReason type) {
        return type != null ? type.getValue() : null;
    }

    public static SubscriptionReason forValue(String value) {
        try {
            return SubscriptionReason.parse(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static SubscriptionReason parse(String value) {
        return SubscriptionReason.valueOf(value.toUpperCase().replace('-', '_').replace("/", "__"));
    }
}

