/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.SearchContentUpdateType;
import org.moera.lib.node.types.notifications.LogPair;
import org.moera.lib.node.types.notifications.NotificationType;
import org.moera.lib.node.types.notifications.SubscriberNotification;
import org.moera.lib.node.types.validate.ValidationUtil;
import org.moera.lib.util.LogUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchContentUpdatedNotification
extends SubscriberNotification {
    private SearchContentUpdateType updateType;

    public SearchContentUpdatedNotification() {
        super(NotificationType.SEARCH_CONTENT_UPDATED);
    }

    public SearchContentUpdateType getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(SearchContentUpdateType updateType) {
        this.updateType = updateType;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.notNull((Object)this.updateType, "search.update-type.missing");
    }

    @Override
    public void logParameters(List<LogPair> parameters) {
        super.logParameters(parameters);
        parameters.add(LogPair.of("updateType", LogUtil.format(this.updateType.toString())));
    }
}

