/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.SearchEngine;
import org.moera.lib.node.types.notifications.LogPair;
import org.moera.lib.node.types.notifications.Notification;
import org.moera.lib.node.types.notifications.NotificationType;
import org.moera.lib.node.types.validate.ValidationUtil;
import org.moera.lib.util.LogUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchEngineClickedNotification
extends Notification {
    private SearchEngine searchEngine;
    private String postingId;
    private String commentId;
    private String mediaId;
    private String heading;
    private long clickedAt;

    public SearchEngineClickedNotification() {
        super(NotificationType.SEARCH_ENGINE_CLICKED);
    }

    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    public void setSearchEngine(SearchEngine searchEngine) {
        this.searchEngine = searchEngine;
    }

    public String getPostingId() {
        return this.postingId;
    }

    public void setPostingId(String postingId) {
        this.postingId = postingId;
    }

    public String getCommentId() {
        return this.commentId;
    }

    public void setCommentId(String commentId) {
        this.commentId = commentId;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public long getClickedAt() {
        return this.clickedAt;
    }

    public void setClickedAt(long clickedAt) {
        this.clickedAt = clickedAt;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.notNull((Object)this.searchEngine, "search.search-engine.missing");
        ValidationUtil.maxSize(this.postingId, 40, "search.posting-id.wrong-size");
        ValidationUtil.maxSize(this.commentId, 40, "search.comment-id.wrong-size");
        ValidationUtil.maxSize(this.mediaId, 40, "search.media-id.wrong-size");
        ValidationUtil.notBlank(this.heading, "search.heading.empty");
        ValidationUtil.maxSize(this.heading, 255, "search.heading.wrong-size");
        ValidationUtil.notNull(this.clickedAt, "search.clicked-at.missing");
    }

    @Override
    public void logParameters(List<LogPair> parameters) {
        super.logParameters(parameters);
        parameters.add(LogPair.of("searchEngine", LogUtil.format(this.searchEngine.toString())));
        parameters.add(LogPair.of("postingId", LogUtil.format(this.postingId)));
        parameters.add(LogPair.of("commentId", LogUtil.format(this.commentId)));
        parameters.add(LogPair.of("mediaId", LogUtil.format(this.mediaId)));
        parameters.add(LogPair.of("heading", LogUtil.format(this.heading)));
    }
}

