/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.List;
import org.moera.lib.crypto.CryptoException;
import org.moera.lib.crypto.FieldWithSchema;
import org.moera.lib.crypto.Fingerprint;
import org.moera.lib.crypto.FingerprintException;
import org.moera.lib.util.LogUtil;
import org.moera.lib.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FingerprintWriter
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(FingerprintWriter.class);
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();

    FingerprintWriter() {
    }

    private void appendNull() {
        log.trace("value: null");
        this.out.write(-1);
    }

    private void append(String str) {
        if (str == null) {
            this.appendNull();
            return;
        }
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        if (log.isTraceEnabled()) {
            log.trace("value: {}", (Object)LogUtil.format(bytes));
        }
        this.append(bytes.length);
        try {
            this.out.write(bytes);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    private void append(boolean b) {
        log.trace("value: {}", (Object)LogUtil.format(b));
        this.out.write((byte)(b ? 1 : 0));
    }

    private void append(long l) {
        int len;
        log.trace("value: {}", (Object)LogUtil.format(l));
        if (l < 252L) {
            len = 1;
        } else if (l <= 65535L) {
            this.out.write(-4);
            len = 2;
        } else if (l <= 0xFFFFFFFFL) {
            this.out.write(-3);
            len = 4;
        } else {
            this.out.write(-2);
            len = 8;
        }
        for (int i = 0; i < len; ++i) {
            this.out.write((byte)(l & 0xFFL));
            l >>= 8;
        }
    }

    private void append(byte[] bytes) {
        this.append(bytes.length);
        if (log.isTraceEnabled()) {
            log.trace("value: {}", (Object)LogUtil.format(bytes));
        }
        try {
            this.out.write(bytes);
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    private void append(List<?> objects) {
        if (log.isTraceEnabled()) {
            log.trace("list: {}", (Object)LogUtil.format(objects.size()));
        }
        try (FingerprintWriter writer = new FingerprintWriter();){
            objects.forEach(writer::append);
            this.append(writer.toBytes());
        }
    }

    void append(Object obj) {
        if (obj == null) {
            this.appendNull();
            return;
        }
        if (obj instanceof Boolean) {
            Boolean value = (Boolean)obj;
            this.append(value);
        } else if (obj instanceof Byte) {
            Byte value = (Byte)obj;
            this.append(value.longValue());
        } else if (obj instanceof Short) {
            Short value = (Short)obj;
            this.append(value.longValue());
        } else if (obj instanceof Integer) {
            Integer value = (Integer)obj;
            this.append(value.longValue());
        } else if (obj instanceof Long) {
            Long value = (Long)obj;
            this.append(value);
        } else if (obj instanceof String) {
            String value = (String)obj;
            this.append(value);
        } else if (obj instanceof byte[]) {
            byte[] value = (byte[])obj;
            this.append(value);
        } else if (obj instanceof Timestamp) {
            Timestamp value = (Timestamp)obj;
            this.append(Util.toEpochSecond(value));
        } else if (obj instanceof InetAddress) {
            InetAddress value = (InetAddress)obj;
            this.append(value.getAddress());
        } else if (obj instanceof List) {
            List value = (List)obj;
            this.append(value);
        } else {
            throw new FingerprintException("%s is not a primitive fingerprint element".formatted(obj.getClass().getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(Fingerprint fingerprint, FieldWithSchema[] schema) {
        log.trace("Fingerprinting {} (ver {})", (Object)fingerprint.getClass().getName(), (Object)fingerprint.getVersion());
        this.append(fingerprint.getVersion());
        try {
            for (FieldWithSchema field : schema) {
                if (field.schema().getClass().isArray()) {
                    if (!FieldWithSchema.class.isAssignableFrom((Class<?>)field.schema().getClass().componentType())) {
                        throw new FingerprintException("fingerprint schema should be a String or a FieldWithSchema[], but got %s".formatted(field.schema().getClass()));
                    }
                    String fieldName = field.name();
                    log.trace("field: {}", (Object)fieldName);
                    Object value = fingerprint.get(fieldName);
                    if (value instanceof Fingerprint) {
                        Fingerprint fingerprintValue = (Fingerprint)value;
                        this.append(fingerprintValue, (FieldWithSchema[])field.schema());
                        continue;
                    }
                    throw new FingerprintException("fingerprint field '%s' should be a Fingerprint".formatted(fieldName));
                }
                log.trace("field: {}", (Object)field.name());
                this.append(fingerprint.get(field.name()));
            }
        }
        finally {
            log.trace("End of fingerprint {}", (Object)fingerprint.getClass().getName());
        }
    }

    @Override
    public void close() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    public byte[] toBytes() {
        return this.out.toByteArray();
    }
}

