/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum OperationStatus {
    WAITING,
    ADDED,
    STARTED,
    SUCCEEDED,
    FAILED,
    UNKNOWN;


    @JsonValue
    public String getValue() {
        return this.name().toLowerCase().replace("__", "/").replace('_', '-');
    }

    public static String toValue(OperationStatus type) {
        return type != null ? type.getValue() : null;
    }

    public static OperationStatus forValue(String value) {
        try {
            return OperationStatus.parse(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static OperationStatus parse(String value) {
        return OperationStatus.valueOf(value.toUpperCase().replace('-', '_').replace("/", "__"));
    }
}

