/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.jsonrpc;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.moera.lib.jsonrpc.JsonRpcError;
import org.moera.lib.naming.NamingError;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class JsonRpcResponse {
    private final String jsonrpc = "2.0";
    private Object result;
    private JsonRpcError error;
    private Object id;

    public JsonRpcResponse() {
    }

    public JsonRpcResponse(Object id, Object result) {
        this.id = id;
        this.result = result;
    }

    public JsonRpcResponse(Object id, JsonRpcError error) {
        this.id = id;
        this.error = error;
    }

    public JsonRpcResponse(Object id, NamingError error) {
        this.id = id;
        this.error = new JsonRpcError(error.getRpcCode(), error.getErrorCode() + ": " + error.getMessage());
    }

    public JsonRpcResponse(Object id, int code, String message) {
        this.id = id;
        this.error = new JsonRpcError(code, message);
    }

    public String getJsonrpc() {
        return "2.0";
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public JsonRpcError getError() {
        return this.error;
    }

    public void setError(JsonRpcError error) {
        this.error = error;
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = id;
    }
}

