/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.moera.lib.node.types.Structure;
import org.moera.lib.node.types.validate.ValidationUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchReactionUpdate
extends Structure
implements Cloneable {
    private String postingId;
    private String commentId;
    private String ownerName;

    public String getPostingId() {
        return this.postingId;
    }

    public void setPostingId(String postingId) {
        this.postingId = postingId;
    }

    public String getCommentId() {
        return this.commentId;
    }

    public void setCommentId(String commentId) {
        this.commentId = commentId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.maxSize(this.postingId, 40, "search.posting-id.wrong-size");
        ValidationUtil.maxSize(this.commentId, 40, "search.comment-id.wrong-size");
        ValidationUtil.maxSize(this.ownerName, 63, "search.owner-name.wrong-size");
    }

    public SearchReactionUpdate clone() {
        try {
            return (SearchReactionUpdate)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Must implement Cloneable", e);
        }
    }
}

