/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.notifications.LogPair;
import org.moera.lib.node.types.notifications.NotificationType;
import org.moera.lib.node.types.notifications.PostingSubscriberNotification;
import org.moera.lib.node.types.notifications.SubscriberNotification;
import org.moera.lib.node.types.validate.ValidationUtil;
import org.moera.lib.util.LogUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PostingHeadingUpdatedNotification
extends SubscriberNotification
implements PostingSubscriberNotification {
    private String postingId;
    private String revisionId;
    private String heading;
    private String description;

    public PostingHeadingUpdatedNotification() {
        super(NotificationType.POSTING_HEADING_UPDATED);
    }

    @Override
    public String getPostingId() {
        return this.postingId;
    }

    public void setPostingId(String postingId) {
        this.postingId = postingId;
    }

    public String getRevisionId() {
        return this.revisionId;
    }

    public void setRevisionId(String revisionId) {
        this.revisionId = revisionId;
    }

    public String getHeading() {
        return this.heading;
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.maxSize(this.postingId, 40, "posting.posting-id.wrong-size");
        ValidationUtil.maxSize(this.revisionId, 40, "posting.revision-id.wrong-size");
        ValidationUtil.maxSize(this.heading, 255, "posting.heading.wrong-size");
        ValidationUtil.maxSize(this.description, 255, "posting.description.wrong-size");
    }

    @Override
    public void logParameters(List<LogPair> parameters) {
        super.logParameters(parameters);
        parameters.add(LogPair.of("postingId", LogUtil.format(this.postingId)));
        parameters.add(LogPair.of("revisionId", LogUtil.format(this.revisionId)));
        parameters.add(LogPair.of("heading", LogUtil.format(this.heading)));
        parameters.add(LogPair.of("description", LogUtil.format(this.description)));
    }
}

