/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.crypto;

import io.github.novacrypto.bip39.JavaxPbkdf2WithHmacSha512;
import io.github.novacrypto.bip39.MnemonicGenerator;
import io.github.novacrypto.bip39.SeedCalculator;
import io.github.novacrypto.bip39.Words;
import io.github.novacrypto.bip39.wordlists.English;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.jcajce.provider.util.DigestFactory;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.moera.lib.crypto.CryptoException;
import org.moera.lib.crypto.FieldWithSchema;
import org.moera.lib.crypto.Fingerprint;
import org.moera.lib.crypto.FingerprintReader;
import org.moera.lib.crypto.FingerprintWriter;
import org.moera.lib.crypto.KeyPair;
import org.moera.lib.crypto.MnemonicKey;
import org.moera.lib.crypto.RestoredFingerprint;
import org.moera.lib.util.LogUtil;
import org.moera.lib.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoUtil {
    private static final Logger log = LoggerFactory.getLogger(CryptoUtil.class);

    private static byte[] encodeUnsigned(BigInteger v, int len) {
        byte[] r = v.toByteArray();
        byte[] e = new byte[len];
        int srcPos = r.length < len ? 0 : r.length - len;
        int dstPos = r.length < len ? len - r.length : 0;
        System.arraycopy(r, srcPos, e, dstPos, r.length - srcPos);
        return e;
    }

    private static BigInteger decodeUnsigned(byte[] e) {
        byte[] r = new byte[e.length + 1];
        System.arraycopy(e, 0, r, r.length - e.length, e.length);
        return new BigInteger(r);
    }

    public static KeyPair generateKey() {
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        SecureRandom random = new SecureRandom();
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("EC", "BC");
            keyPairGenerator.initialize((AlgorithmParameterSpec)ecSpec, random);
            return new KeyPair(keyPairGenerator.generateKeyPair());
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException(e);
        }
    }

    public static MnemonicKey generateMnemonicKey() {
        try {
            SecureRandom random = new SecureRandom();
            byte[] entropy = new byte[Words.TWENTY_FOUR.byteLength()];
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
            KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
            String secret = null;
            StringBuilder mnemonic = null;
            BigInteger p = ecSpec.getCurve().getField().getCharacteristic();
            BigInteger d = BigInteger.ZERO;
            while (d.equals(BigInteger.ZERO)) {
                random.nextBytes(entropy);
                mnemonic = new StringBuilder();
                new MnemonicGenerator(English.INSTANCE).createMnemonic(entropy, mnemonic::append);
                byte[] seed = new SeedCalculator(JavaxPbkdf2WithHmacSha512.INSTANCE).calculateSeed(mnemonic.toString(), "");
                secret = Util.base64encode(entropy);
                d = new BigInteger(1, seed).remainder(p);
            }
            ECPoint q = ecSpec.getG().multiply(d);
            ECPublicKeySpec pubSpec = new ECPublicKeySpec(q, (ECParameterSpec)ecSpec);
            ECPublicKey publicKey = (ECPublicKey)keyFactory.generatePublic((KeySpec)pubSpec);
            return new MnemonicKey(secret, mnemonic.toString(), publicKey);
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException(e);
        }
    }

    public static String secretToMnemonic(String secret) {
        byte[] entropy = Util.base64decode(secret);
        StringBuilder buf = new StringBuilder();
        new MnemonicGenerator(English.INSTANCE).createMnemonic(entropy, buf::append);
        return buf.toString();
    }

    public static ECPrivateKey mnemonicToPrivateKey(String mnemonic) {
        byte[] seed = new SeedCalculator(JavaxPbkdf2WithHmacSha512.INSTANCE).calculateSeed(mnemonic, "");
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
            BigInteger p = ecSpec.getCurve().getField().getCharacteristic();
            BigInteger d = new BigInteger(1, seed).remainder(p);
            ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(d, (ECParameterSpec)ecSpec);
            return (ECPrivateKey)keyFactory.generatePrivate((KeySpec)privateKeySpec);
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException(e);
        }
    }

    public static byte[] rawPublicKey(ECPublicKey publicKey) {
        byte[] x = CryptoUtil.encodeUnsigned(publicKey.getW().getAffineX(), 32);
        byte[] y = CryptoUtil.encodeUnsigned(publicKey.getW().getAffineY(), 32);
        byte[] rawKey = new byte[x.length + y.length];
        System.arraycopy(x, 0, rawKey, 0, x.length);
        System.arraycopy(y, 0, rawKey, x.length, y.length);
        return rawKey;
    }

    public static ECPublicKey rawToPublicKey(byte[] rawKey) {
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        System.arraycopy(rawKey, 0, x, 0, x.length);
        System.arraycopy(rawKey, x.length, y, 0, y.length);
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        ECPoint w = parameterSpec.getCurve().createPoint(CryptoUtil.decodeUnsigned(x), CryptoUtil.decodeUnsigned(y));
        ECPublicKeySpec keySpec = new ECPublicKeySpec(w, (ECParameterSpec)parameterSpec);
        try {
            return (ECPublicKey)KeyFactory.getInstance("EC", "BC").generatePublic((KeySpec)keySpec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new CryptoException(e);
        }
    }

    public static byte[] rawPrivateKey(ECPrivateKey privateKey) {
        return CryptoUtil.encodeUnsigned(privateKey.getS(), 32);
    }

    public static ECPrivateKey rawToPrivateKey(byte[] rawKey) {
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        ECPrivateKeySpec keySpec = new ECPrivateKeySpec(CryptoUtil.decodeUnsigned(rawKey), (ECParameterSpec)parameterSpec);
        try {
            return (ECPrivateKey)KeyFactory.getInstance("EC", "BC").generatePrivate((KeySpec)keySpec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new CryptoException(e);
        }
    }

    public static String token() {
        byte[] random = new byte[32];
        try {
            new SecureRandom().nextBytes(random);
            return Util.base64urlencode(MessageDigest.getInstance("SHA-256", "BC").digest(random));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new CryptoException(e);
        }
    }

    public static byte[] fingerprint(Fingerprint fingerprint, FieldWithSchema[] schema) {
        try (FingerprintWriter writer = new FingerprintWriter();){
            writer.append(fingerprint, schema);
            byte[] byArray = writer.toBytes();
            return byArray;
        }
    }

    public static byte[] fingerprint(String text) {
        try (FingerprintWriter writer = new FingerprintWriter();){
            writer.append((Object)text);
            byte[] byArray = writer.toBytes();
            return byArray;
        }
    }

    public static RestoredFingerprint restoreFingerprint(byte[] bytes, FieldWithSchema[] schema) {
        return CryptoUtil.restoreFingerprint(bytes, version -> schema);
    }

    public static RestoredFingerprint restoreFingerprint(byte[] bytes, Function<Integer, FieldWithSchema[]> schemaProvider) {
        try (FingerprintReader reader = new FingerprintReader(bytes);){
            Fingerprint fingerprint = reader.read(schemaProvider);
            RestoredFingerprint restoredFingerprint = new RestoredFingerprint(fingerprint, reader.available());
            return restoredFingerprint;
        }
    }

    public static byte[] digest(byte[] fingerprint) {
        Digest digest = DigestFactory.getDigest((String)"SHA3-256");
        digest.update(fingerprint, 0, fingerprint.length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        log.debug("Digest: " + LogUtil.format(result));
        return result;
    }

    public static List<byte[]> digest(Collection<byte[]> fingerprint) {
        return fingerprint != null ? fingerprint.stream().map(CryptoUtil::digest).toList() : null;
    }

    public static byte[] sign(byte[] fingerprint, byte[] privateKey) {
        return CryptoUtil.sign(fingerprint, CryptoUtil.rawToPrivateKey(privateKey));
    }

    public static byte[] sign(byte[] fingerprint, ECPrivateKey privateKey) {
        try {
            Signature signature = Signature.getInstance("SHA3-256withECDSA", "BC");
            signature.initSign(privateKey, new SecureRandom());
            signature.update(fingerprint);
            byte[] result = signature.sign();
            log.debug("Signature: " + LogUtil.format(result));
            return result;
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException(e);
        }
    }

    public static boolean verifySignature(byte[] fingerprint, byte[] signature, byte[] publicKey) {
        return CryptoUtil.verifySignature(fingerprint, signature, CryptoUtil.rawToPublicKey(publicKey));
    }

    public static boolean verifySignature(byte[] fingerprint, byte[] signature, ECPublicKey publicKey) {
        try {
            Signature sign = Signature.getInstance("SHA3-256withECDSA", "BC");
            sign.initVerify(publicKey);
            sign.update(fingerprint);
            log.debug("Verifying signature: " + LogUtil.format(signature));
            boolean correct = sign.verify(signature);
            log.debug("Signature is {}", (Object)(correct ? "correct" : "incorrect"));
            return correct;
        }
        catch (SignatureException e) {
            log.debug("Signature is incorrect: " + e.getMessage());
            return false;
        }
        catch (GeneralSecurityException e) {
            throw new CryptoException(e);
        }
    }
}

