/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.jsonrpc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.function.Function;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.moera.lib.jsonrpc.JsonRpcConnectionException;
import org.moera.lib.jsonrpc.JsonRpcException;
import org.moera.lib.jsonrpc.JsonRpcRequest;
import org.moera.lib.jsonrpc.JsonRpcResponse;

public class OkHttpFetcher
implements Function<JsonRpcRequest, JsonRpcResponse> {
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json");
    private final String url;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final OkHttpClient client = new OkHttpClient();

    public OkHttpFetcher(String url) {
        this.url = url;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public JsonRpcResponse apply(JsonRpcRequest jsonRpcRequest) {
        assert (MEDIA_TYPE_JSON != null);
        try {
            String body = this.objectMapper.writeValueAsString((Object)jsonRpcRequest);
            Request request = new Request.Builder().url(this.url).method("POST", RequestBody.create((String)body, (MediaType)MEDIA_TYPE_JSON)).addHeader("accept", MEDIA_TYPE_JSON.toString()).build();
            try (Response response = this.client.newCall(request).execute();){
                if (response.body() == null) {
                    throw new JsonRpcException("Request returned an empty result");
                }
                try {
                    JsonRpcResponse jsonRpcResponse = (JsonRpcResponse)this.objectMapper.readValue(response.body().string(), JsonRpcResponse.class);
                    return jsonRpcResponse;
                }
                catch (JsonProcessingException e) {
                    throw new JsonRpcException("Error parsing JSON", e);
                }
            }
            catch (IOException e) {
                throw new JsonRpcConnectionException("Request failed", e);
            }
        }
        catch (JsonProcessingException e) {
            throw new JsonRpcException("Error converting to JSON", e);
        }
    }
}

