/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node;

import com.fasterxml.jackson.core.type.TypeReference;
import java.nio.file.Path;
import org.moera.lib.node.NodeApiClient;
import org.moera.lib.node.QueryParam;
import org.moera.lib.node.exception.MoeraNodeException;
import org.moera.lib.node.types.ActivityReactionFilter;
import org.moera.lib.node.types.ActivityReactionInfo;
import org.moera.lib.node.types.AskDescription;
import org.moera.lib.node.types.AsyncOperationCreated;
import org.moera.lib.node.types.AvatarAttributes;
import org.moera.lib.node.types.AvatarInfo;
import org.moera.lib.node.types.AvatarOrdinal;
import org.moera.lib.node.types.AvatarsOrdered;
import org.moera.lib.node.types.BlockedByUserFilter;
import org.moera.lib.node.types.BlockedByUserInfo;
import org.moera.lib.node.types.BlockedInstantAttributes;
import org.moera.lib.node.types.BlockedInstantFilter;
import org.moera.lib.node.types.BlockedInstantInfo;
import org.moera.lib.node.types.BlockedUserAttributes;
import org.moera.lib.node.types.BlockedUserFilter;
import org.moera.lib.node.types.BlockedUserInfo;
import org.moera.lib.node.types.BlockedUsersChecksums;
import org.moera.lib.node.types.CarteAttributes;
import org.moera.lib.node.types.CarteSet;
import org.moera.lib.node.types.CarteVerificationInfo;
import org.moera.lib.node.types.ClientCarte;
import org.moera.lib.node.types.CommentCreated;
import org.moera.lib.node.types.CommentInfo;
import org.moera.lib.node.types.CommentMassAttributes;
import org.moera.lib.node.types.CommentRevisionInfo;
import org.moera.lib.node.types.CommentSourceText;
import org.moera.lib.node.types.CommentText;
import org.moera.lib.node.types.CommentTotalInfo;
import org.moera.lib.node.types.CommentsSliceInfo;
import org.moera.lib.node.types.ContactInfo;
import org.moera.lib.node.types.Credentials;
import org.moera.lib.node.types.CredentialsChange;
import org.moera.lib.node.types.CredentialsCreated;
import org.moera.lib.node.types.DeleteNodeStatus;
import org.moera.lib.node.types.DeleteNodeText;
import org.moera.lib.node.types.DomainAttributes;
import org.moera.lib.node.types.DomainAvailable;
import org.moera.lib.node.types.DomainInfo;
import org.moera.lib.node.types.DraftInfo;
import org.moera.lib.node.types.DraftText;
import org.moera.lib.node.types.DraftType;
import org.moera.lib.node.types.EmailHint;
import org.moera.lib.node.types.EntryInfo;
import org.moera.lib.node.types.Features;
import org.moera.lib.node.types.FeedInfo;
import org.moera.lib.node.types.FeedSliceInfo;
import org.moera.lib.node.types.FeedStatus;
import org.moera.lib.node.types.FeedStatusChange;
import org.moera.lib.node.types.FriendDescription;
import org.moera.lib.node.types.FriendGroupDescription;
import org.moera.lib.node.types.FriendGroupInfo;
import org.moera.lib.node.types.FriendInfo;
import org.moera.lib.node.types.FriendOfInfo;
import org.moera.lib.node.types.GrantChange;
import org.moera.lib.node.types.GrantInfo;
import org.moera.lib.node.types.KeyMnemonic;
import org.moera.lib.node.types.LinkPreviewInfo;
import org.moera.lib.node.types.NameToRegister;
import org.moera.lib.node.types.NodeNameInfo;
import org.moera.lib.node.types.NotificationPacket;
import org.moera.lib.node.types.PeopleGeneralInfo;
import org.moera.lib.node.types.PluginDescription;
import org.moera.lib.node.types.PluginInfo;
import org.moera.lib.node.types.PostingInfo;
import org.moera.lib.node.types.PostingRevisionInfo;
import org.moera.lib.node.types.PostingSourceText;
import org.moera.lib.node.types.PostingText;
import org.moera.lib.node.types.PrivateMediaFileInfo;
import org.moera.lib.node.types.ProfileAttributes;
import org.moera.lib.node.types.ProfileInfo;
import org.moera.lib.node.types.PublicMediaFileInfo;
import org.moera.lib.node.types.PushRelayClientAttributes;
import org.moera.lib.node.types.ReactionAttributes;
import org.moera.lib.node.types.ReactionCreated;
import org.moera.lib.node.types.ReactionDescription;
import org.moera.lib.node.types.ReactionInfo;
import org.moera.lib.node.types.ReactionOverride;
import org.moera.lib.node.types.ReactionTotalsFilter;
import org.moera.lib.node.types.ReactionTotalsInfo;
import org.moera.lib.node.types.ReactionsFilter;
import org.moera.lib.node.types.ReactionsSliceInfo;
import org.moera.lib.node.types.RecommendedPostingInfo;
import org.moera.lib.node.types.RegisteredNameSecret;
import org.moera.lib.node.types.RemotePostingVerificationInfo;
import org.moera.lib.node.types.RemoteReactionVerificationInfo;
import org.moera.lib.node.types.Result;
import org.moera.lib.node.types.SearchHashtagFilter;
import org.moera.lib.node.types.SearchHashtagSliceInfo;
import org.moera.lib.node.types.SearchHistoryInfo;
import org.moera.lib.node.types.SearchHistoryText;
import org.moera.lib.node.types.SearchNodeFilter;
import org.moera.lib.node.types.SearchNodeInfo;
import org.moera.lib.node.types.SearchNodePageInfo;
import org.moera.lib.node.types.SearchTextFilter;
import org.moera.lib.node.types.SearchTextPageInfo;
import org.moera.lib.node.types.SettingInfo;
import org.moera.lib.node.types.SettingMetaAttributes;
import org.moera.lib.node.types.SettingMetaInfo;
import org.moera.lib.node.types.SheriffComplaintDecisionText;
import org.moera.lib.node.types.SheriffComplaintGroupInfo;
import org.moera.lib.node.types.SheriffComplaintGroupsSliceInfo;
import org.moera.lib.node.types.SheriffComplaintInfo;
import org.moera.lib.node.types.SheriffComplaintStatus;
import org.moera.lib.node.types.SheriffComplaintText;
import org.moera.lib.node.types.SheriffOrderAttributes;
import org.moera.lib.node.types.SheriffOrderDetails;
import org.moera.lib.node.types.SheriffOrderInfo;
import org.moera.lib.node.types.SheriffOrdersSliceInfo;
import org.moera.lib.node.types.StoryAttributes;
import org.moera.lib.node.types.StoryInfo;
import org.moera.lib.node.types.SubscriberDescription;
import org.moera.lib.node.types.SubscriberInfo;
import org.moera.lib.node.types.SubscriberOverride;
import org.moera.lib.node.types.SubscriptionDescription;
import org.moera.lib.node.types.SubscriptionFilter;
import org.moera.lib.node.types.SubscriptionInfo;
import org.moera.lib.node.types.SubscriptionOverride;
import org.moera.lib.node.types.SubscriptionType;
import org.moera.lib.node.types.TokenAttributes;
import org.moera.lib.node.types.TokenInfo;
import org.moera.lib.node.types.TokenUpdate;
import org.moera.lib.node.types.UserListInfo;
import org.moera.lib.node.types.UserListItemAttributes;
import org.moera.lib.node.types.UserListItemInfo;
import org.moera.lib.node.types.UserListSliceInfo;
import org.moera.lib.node.types.WhoAmI;

public class MoeraNode
extends NodeApiClient {
    public MoeraNode() {
    }

    public MoeraNode(String nodeUrl) {
        super(nodeUrl);
    }

    public ActivityReactionInfo[] searchActivityReactions(ActivityReactionFilter filter) throws MoeraNodeException {
        String location = "/activity/reactions/search";
        TypeReference<ActivityReactionInfo[]> returnTypeRef = new TypeReference<ActivityReactionInfo[]>(){};
        return this.call(location, null, "POST", (Object)filter, returnTypeRef);
    }

    public SearchHistoryInfo[] getSearchHistory(String prefix, Integer limit) throws MoeraNodeException {
        String location = "/activity/search";
        QueryParam[] params = new QueryParam[]{QueryParam.of("prefix", prefix), QueryParam.of("limit", limit)};
        TypeReference<SearchHistoryInfo[]> returnTypeRef = new TypeReference<SearchHistoryInfo[]>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public SearchHistoryInfo saveToSearchHistory(SearchHistoryText historyText) throws MoeraNodeException {
        String location = "/activity/search";
        TypeReference<SearchHistoryInfo> returnTypeRef = new TypeReference<SearchHistoryInfo>(){};
        return this.call(location, null, "POST", (Object)historyText, returnTypeRef);
    }

    public Result deleteFromSearchHistory(String query) throws MoeraNodeException {
        String location = "/activity/search";
        QueryParam[] params = new QueryParam[]{QueryParam.of("query", query)};
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, params, "DELETE", null, returnTypeRef);
    }

    public SheriffOrdersSliceInfo getRemoteSheriffOrdersSlice(Long after, Long before, Integer limit) throws MoeraNodeException {
        String location = "/activity/sheriff/orders";
        QueryParam[] params = new QueryParam[]{QueryParam.of("after", after), QueryParam.of("before", before), QueryParam.of("limit", limit)};
        TypeReference<SheriffOrdersSliceInfo> returnTypeRef = new TypeReference<SheriffOrdersSliceInfo>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public RemotePostingVerificationInfo getRemotePostingVerificationStatus(String id) throws MoeraNodeException {
        String location = "/async-operations/remote-posting-verification/%s".formatted(this.ue(id));
        TypeReference<RemotePostingVerificationInfo> returnTypeRef = new TypeReference<RemotePostingVerificationInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public RemoteReactionVerificationInfo getRemoteReactionVerificationStatus(String id) throws MoeraNodeException {
        String location = "/async-operations/remote-reaction-verification/%s".formatted(this.ue(id));
        TypeReference<RemoteReactionVerificationInfo> returnTypeRef = new TypeReference<RemoteReactionVerificationInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public AvatarInfo[] getAvatars() throws MoeraNodeException {
        String location = "/avatars";
        TypeReference<AvatarInfo[]> returnTypeRef = new TypeReference<AvatarInfo[]>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public AvatarInfo createAvatar(AvatarAttributes avatar) throws MoeraNodeException {
        String location = "/avatars";
        TypeReference<AvatarInfo> returnTypeRef = new TypeReference<AvatarInfo>(){};
        return this.call(location, null, "POST", (Object)avatar, returnTypeRef);
    }

    public AvatarInfo getAvatar(String id) throws MoeraNodeException {
        String location = "/avatars/%s".formatted(this.ue(id));
        TypeReference<AvatarInfo> returnTypeRef = new TypeReference<AvatarInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public Result deleteAvatar(String id) throws MoeraNodeException {
        String location = "/avatars/%s".formatted(this.ue(id));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public AvatarOrdinal[] reorderAvatars(AvatarsOrdered order) throws MoeraNodeException {
        String location = "/avatars/reorder";
        TypeReference<AvatarOrdinal[]> returnTypeRef = new TypeReference<AvatarOrdinal[]>(){};
        return this.call(location, null, "POST", (Object)order, returnTypeRef);
    }

    public BlockedInstantInfo blockInstant(BlockedInstantAttributes instant) throws MoeraNodeException {
        String location = "/blocked-instants";
        TypeReference<BlockedInstantInfo> returnTypeRef = new TypeReference<BlockedInstantInfo>(){};
        return this.call(location, null, "POST", (Object)instant, returnTypeRef);
    }

    public BlockedInstantInfo getBlockedInstant(String id) throws MoeraNodeException {
        String location = "/blocked-instants/%s".formatted(this.ue(id));
        TypeReference<BlockedInstantInfo> returnTypeRef = new TypeReference<BlockedInstantInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public Result unblockInstant(String id) throws MoeraNodeException {
        String location = "/blocked-instants/%s".formatted(this.ue(id));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public BlockedInstantInfo[] searchBlockedInstants(BlockedInstantFilter filter) throws MoeraNodeException {
        String location = "/blocked-instants/search";
        TypeReference<BlockedInstantInfo[]> returnTypeRef = new TypeReference<BlockedInstantInfo[]>(){};
        return this.call(location, null, "POST", (Object)filter, returnTypeRef);
    }

    public BlockedUserInfo blockUser(BlockedUserAttributes user) throws MoeraNodeException {
        String location = "/people/blocked-users";
        TypeReference<BlockedUserInfo> returnTypeRef = new TypeReference<BlockedUserInfo>(){};
        return this.call(location, null, "POST", (Object)user, returnTypeRef);
    }

    public BlockedUserInfo getBlockedUser(String id) throws MoeraNodeException {
        String location = "/people/blocked-users/%s".formatted(this.ue(id));
        TypeReference<BlockedUserInfo> returnTypeRef = new TypeReference<BlockedUserInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public Result unblockUser(String id) throws MoeraNodeException {
        String location = "/people/blocked-users/%s".formatted(this.ue(id));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public BlockedUserInfo[] searchBlockedUsers(BlockedUserFilter filter) throws MoeraNodeException {
        String location = "/people/blocked-users/search";
        TypeReference<BlockedUserInfo[]> returnTypeRef = new TypeReference<BlockedUserInfo[]>(){};
        return this.call(location, null, "POST", (Object)filter, returnTypeRef);
    }

    public BlockedUsersChecksums getBlockedUsersChecksums() throws MoeraNodeException {
        String location = "/people/blocked-users/checksums";
        TypeReference<BlockedUsersChecksums> returnTypeRef = new TypeReference<BlockedUsersChecksums>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public BlockedByUserInfo getBlockedByUser(String id) throws MoeraNodeException {
        String location = "/people/blocked-by-users/%s".formatted(this.ue(id));
        TypeReference<BlockedByUserInfo> returnTypeRef = new TypeReference<BlockedByUserInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public BlockedByUserInfo[] searchBlockedByUsers(BlockedByUserFilter filter) throws MoeraNodeException {
        String location = "/people/blocked-by-users/search";
        TypeReference<BlockedByUserInfo[]> returnTypeRef = new TypeReference<BlockedByUserInfo[]>(){};
        return this.call(location, null, "POST", (Object)filter, returnTypeRef);
    }

    public CarteSet createCartes(CarteAttributes attributes) throws MoeraNodeException {
        String location = "/cartes";
        TypeReference<CarteSet> returnTypeRef = new TypeReference<CarteSet>(){};
        return this.call(location, null, "POST", (Object)attributes, returnTypeRef);
    }

    public CarteVerificationInfo verifyCarte(ClientCarte clientCarte) throws MoeraNodeException {
        String location = "/cartes/verify";
        TypeReference<CarteVerificationInfo> returnTypeRef = new TypeReference<CarteVerificationInfo>(){};
        return this.call(location, null, "POST", (Object)clientCarte, returnTypeRef);
    }

    public CommentsSliceInfo getCommentsSlice(String postingId, Long after, Long before, Integer limit) throws MoeraNodeException {
        String location = "/postings/%s/comments".formatted(this.ue(postingId));
        QueryParam[] params = new QueryParam[]{QueryParam.of("after", after), QueryParam.of("before", before), QueryParam.of("limit", limit)};
        TypeReference<CommentsSliceInfo> returnTypeRef = new TypeReference<CommentsSliceInfo>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public CommentCreated createComment(String postingId, CommentText comment) throws MoeraNodeException {
        String location = "/postings/%s/comments".formatted(this.ue(postingId));
        TypeReference<CommentCreated> returnTypeRef = new TypeReference<CommentCreated>(){};
        return this.call(location, null, "POST", (Object)comment, returnTypeRef);
    }

    public CommentInfo getComment(String postingId, String commentId, boolean withSource) throws MoeraNodeException {
        String include = this.commaSeparatedFlags(QueryParam.of("source", withSource));
        String location = "/postings/%s/comments/%s".formatted(this.ue(postingId), this.ue(commentId));
        QueryParam[] params = new QueryParam[]{QueryParam.of("include", include)};
        TypeReference<CommentInfo> returnTypeRef = new TypeReference<CommentInfo>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public Result updateAllComments(String postingId, CommentMassAttributes attributes) throws MoeraNodeException {
        String location = "/postings/%s/comments".formatted(this.ue(postingId));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "PUT", (Object)attributes, returnTypeRef);
    }

    public CommentInfo updateComment(String postingId, String commentId, CommentText comment) throws MoeraNodeException {
        String location = "/postings/%s/comments/%s".formatted(this.ue(postingId), this.ue(commentId));
        TypeReference<CommentInfo> returnTypeRef = new TypeReference<CommentInfo>(){};
        return this.call(location, null, "PUT", (Object)comment, returnTypeRef);
    }

    public CommentTotalInfo deleteComment(String postingId, String commentId) throws MoeraNodeException {
        String location = "/postings/%s/comments/%s".formatted(this.ue(postingId), this.ue(commentId));
        TypeReference<CommentTotalInfo> returnTypeRef = new TypeReference<CommentTotalInfo>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public PostingInfo[] getPostingsAttachedToComment(String postingId, String commentId) throws MoeraNodeException {
        String location = "/postings/%s/comments/%s/attached".formatted(this.ue(postingId), this.ue(commentId));
        TypeReference<PostingInfo[]> returnTypeRef = new TypeReference<PostingInfo[]>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public CommentRevisionInfo[] getCommentRevisions(String postingId, String commentId) throws MoeraNodeException {
        String location = "/postings/%s/comments/%s/revisions".formatted(this.ue(postingId), this.ue(commentId));
        TypeReference<CommentRevisionInfo[]> returnTypeRef = new TypeReference<CommentRevisionInfo[]>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public CommentRevisionInfo getCommentRevision(String postingId, String commentId, String id) throws MoeraNodeException {
        String location = "/postings/%s/comments/%s/revisions/%s".formatted(this.ue(postingId), this.ue(commentId), this.ue(id));
        TypeReference<CommentRevisionInfo> returnTypeRef = new TypeReference<CommentRevisionInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public ReactionCreated createCommentReaction(String postingId, String commentId, ReactionDescription reaction) throws MoeraNodeException {
        String location = "/postings/%s/comments/%s/reactions".formatted(this.ue(postingId), this.ue(commentId));
        TypeReference<ReactionCreated> returnTypeRef = new TypeReference<ReactionCreated>(){};
        return this.call(location, null, "POST", (Object)reaction, returnTypeRef);
    }

    public ReactionInfo updateCommentReaction(String postingId, String commentId, String ownerName, ReactionOverride reaction) throws MoeraNodeException {
        String location = "/postings/%s/comments/%s/reactions/%s".formatted(this.ue(postingId), this.ue(commentId), this.ue(ownerName));
        TypeReference<ReactionInfo> returnTypeRef = new TypeReference<ReactionInfo>(){};
        return this.call(location, null, "PUT", (Object)reaction, returnTypeRef);
    }

    public ReactionsSliceInfo getCommentReactionsSlice(String postingId, String commentId, Boolean negative, Integer emoji, Long before, Integer limit) throws MoeraNodeException {
        String location = "/postings/%s/comments/%s/reactions".formatted(this.ue(postingId), this.ue(commentId));
        QueryParam[] params = new QueryParam[]{QueryParam.of("negative", negative), QueryParam.of("emoji", emoji), QueryParam.of("before", before), QueryParam.of("limit", limit)};
        TypeReference<ReactionsSliceInfo> returnTypeRef = new TypeReference<ReactionsSliceInfo>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public ReactionInfo getCommentReaction(String postingId, String commentId, String ownerName) throws MoeraNodeException {
        String location = "/postings/%s/comments/%s/reactions/%s".formatted(this.ue(postingId), this.ue(commentId), this.ue(ownerName));
        TypeReference<ReactionInfo> returnTypeRef = new TypeReference<ReactionInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public Result deleteAllCommentReactions(String postingId, String commentId) throws MoeraNodeException {
        String location = "/postings/%s/comments/%s/reactions".formatted(this.ue(postingId), this.ue(commentId));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public ReactionTotalsInfo deleteCommentReaction(String postingId, String commentId, String ownerName) throws MoeraNodeException {
        String location = "/postings/%s/comments/%s/reactions/%s".formatted(this.ue(postingId), this.ue(commentId), this.ue(ownerName));
        TypeReference<ReactionTotalsInfo> returnTypeRef = new TypeReference<ReactionTotalsInfo>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public ReactionTotalsInfo getCommentReactionTotals(String postingId, String commentId) throws MoeraNodeException {
        String location = "/postings/%s/comments/%s/reaction-totals".formatted(this.ue(postingId), this.ue(commentId));
        TypeReference<ReactionTotalsInfo> returnTypeRef = new TypeReference<ReactionTotalsInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public ContactInfo[] getContacts(String query, Integer limit) throws MoeraNodeException {
        String location = "/people/contacts";
        QueryParam[] params = new QueryParam[]{QueryParam.of("query", query), QueryParam.of("limit", limit)};
        TypeReference<ContactInfo[]> returnTypeRef = new TypeReference<ContactInfo[]>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public CredentialsCreated checkCredentials() throws MoeraNodeException {
        String location = "/credentials";
        TypeReference<CredentialsCreated> returnTypeRef = new TypeReference<CredentialsCreated>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public Result createCredentials(Credentials credentials) throws MoeraNodeException {
        String location = "/credentials";
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "POST", (Object)credentials, returnTypeRef);
    }

    public Result updateCredentials(CredentialsChange credentials) throws MoeraNodeException {
        String location = "/credentials";
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "PUT", (Object)credentials, returnTypeRef);
    }

    public Result deleteCredentials() throws MoeraNodeException {
        String location = "/credentials";
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public EmailHint resetCredentials() throws MoeraNodeException {
        String location = "/credentials/reset";
        TypeReference<EmailHint> returnTypeRef = new TypeReference<EmailHint>(){};
        return this.call(location, null, "POST", null, returnTypeRef);
    }

    public PostingInfo[] getDeletedPostings(Integer page, Integer limit) throws MoeraNodeException {
        String location = "/deleted-postings";
        QueryParam[] params = new QueryParam[]{QueryParam.of("page", page), QueryParam.of("limit", limit)};
        TypeReference<PostingInfo[]> returnTypeRef = new TypeReference<PostingInfo[]>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public PostingInfo getDeletedPosting(String id) throws MoeraNodeException {
        String location = "/deleted-postings/%s".formatted(this.ue(id));
        TypeReference<PostingInfo> returnTypeRef = new TypeReference<PostingInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public PostingInfo restoreDeletedPosting(String id) throws MoeraNodeException {
        String location = "/deleted-postings/%s/restore".formatted(this.ue(id));
        TypeReference<PostingInfo> returnTypeRef = new TypeReference<PostingInfo>(){};
        return this.call(location, null, "POST", null, returnTypeRef);
    }

    public PostingRevisionInfo[] getDeletePostingRevisions(String postingId, Integer limit) throws MoeraNodeException {
        String location = "/deleted-postings/%s/revisions".formatted(this.ue(postingId));
        QueryParam[] params = new QueryParam[]{QueryParam.of("limit", limit)};
        TypeReference<PostingRevisionInfo[]> returnTypeRef = new TypeReference<PostingRevisionInfo[]>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public PostingRevisionInfo getDeletedPostingRevision(String postingId, String id) throws MoeraNodeException {
        String location = "/deleted-postings/%s/revisions/%s".formatted(this.ue(postingId), this.ue(id));
        TypeReference<PostingRevisionInfo> returnTypeRef = new TypeReference<PostingRevisionInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public PostingRevisionInfo restoreDeletedPostingRevision(String postingId, String id) throws MoeraNodeException {
        String location = "/postings/%s/revisions/%s/restore".formatted(this.ue(postingId), this.ue(id));
        TypeReference<PostingRevisionInfo> returnTypeRef = new TypeReference<PostingRevisionInfo>(){};
        return this.call(location, null, "POST", null, returnTypeRef);
    }

    public DomainInfo[] getDomains() throws MoeraNodeException {
        String location = "/domains";
        TypeReference<DomainInfo[]> returnTypeRef = new TypeReference<DomainInfo[]>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public DomainInfo getDomain(String name) throws MoeraNodeException {
        String location = "/domains/%s".formatted(this.ue(name));
        TypeReference<DomainInfo> returnTypeRef = new TypeReference<DomainInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public DomainInfo createDomain(DomainAttributes domain) throws MoeraNodeException {
        String location = "/domains";
        TypeReference<DomainInfo> returnTypeRef = new TypeReference<DomainInfo>(){};
        return this.call(location, null, "POST", (Object)domain, returnTypeRef);
    }

    public DomainInfo updateDomain(String name, DomainAttributes domain) throws MoeraNodeException {
        String location = "/domains/%s".formatted(this.ue(name));
        TypeReference<DomainInfo> returnTypeRef = new TypeReference<DomainInfo>(){};
        return this.call(location, null, "PUT", (Object)domain, returnTypeRef);
    }

    public Result deleteDomain(String name) throws MoeraNodeException {
        String location = "/domains/%s".formatted(this.ue(name));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public DomainAvailable isDomainAvailable(String nodeName) throws MoeraNodeException {
        String location = "/domains/available";
        QueryParam[] params = new QueryParam[]{QueryParam.of("nodeName", nodeName)};
        TypeReference<DomainAvailable> returnTypeRef = new TypeReference<DomainAvailable>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public DraftInfo[] getDrafts(DraftType draftType, String nodeName, String postingId, String commentId, Integer page, Integer limit) throws MoeraNodeException {
        String location = "/drafts";
        QueryParam[] params = new QueryParam[]{QueryParam.of("draftType", (Object)draftType), QueryParam.of("nodeName", nodeName), QueryParam.of("postingId", postingId), QueryParam.of("commentId", commentId), QueryParam.of("page", page), QueryParam.of("limit", limit)};
        TypeReference<DraftInfo[]> returnTypeRef = new TypeReference<DraftInfo[]>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public DraftInfo createDraft(DraftText draft) throws MoeraNodeException {
        String location = "/drafts";
        TypeReference<DraftInfo> returnTypeRef = new TypeReference<DraftInfo>(){};
        return this.call(location, null, "POST", (Object)draft, returnTypeRef);
    }

    public DraftInfo getDraft(String id) throws MoeraNodeException {
        String location = "/drafts/%s".formatted(this.ue(id));
        TypeReference<DraftInfo> returnTypeRef = new TypeReference<DraftInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public DraftInfo updateDraft(String id, DraftText draft) throws MoeraNodeException {
        String location = "/drafts/%s".formatted(this.ue(id));
        TypeReference<DraftInfo> returnTypeRef = new TypeReference<DraftInfo>(){};
        return this.call(location, null, "PUT", (Object)draft, returnTypeRef);
    }

    public Result deleteDraft(String id) throws MoeraNodeException {
        String location = "/drafts/%s".formatted(this.ue(id));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public Features getFeatures() throws MoeraNodeException {
        String location = "/features";
        TypeReference<Features> returnTypeRef = new TypeReference<Features>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public FeedInfo[] getFeeds() throws MoeraNodeException {
        String location = "/feeds";
        TypeReference<FeedInfo[]> returnTypeRef = new TypeReference<FeedInfo[]>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public FeedInfo getFeedGeneral(String feedName) throws MoeraNodeException {
        String location = "/feeds/%s".formatted(this.ue(feedName));
        TypeReference<FeedInfo> returnTypeRef = new TypeReference<FeedInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public FeedStatus getFeedStatus(String feedName) throws MoeraNodeException {
        String location = "/feeds/%s/status".formatted(this.ue(feedName));
        TypeReference<FeedStatus> returnTypeRef = new TypeReference<FeedStatus>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public FeedStatus updateFeedStatus(String feedName, FeedStatusChange change) throws MoeraNodeException {
        String location = "/feeds/%s/status".formatted(this.ue(feedName));
        TypeReference<FeedStatus> returnTypeRef = new TypeReference<FeedStatus>(){};
        return this.call(location, null, "PUT", (Object)change, returnTypeRef);
    }

    public FeedSliceInfo getFeedSlice(String feedName, Long after, Long before, Integer limit) throws MoeraNodeException {
        String location = "/feeds/%s/stories".formatted(this.ue(feedName));
        QueryParam[] params = new QueryParam[]{QueryParam.of("after", after), QueryParam.of("before", before), QueryParam.of("limit", limit)};
        TypeReference<FeedSliceInfo> returnTypeRef = new TypeReference<FeedSliceInfo>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public FriendGroupInfo[] getFriendGroups() throws MoeraNodeException {
        String location = "/people/friends/groups";
        TypeReference<FriendGroupInfo[]> returnTypeRef = new TypeReference<FriendGroupInfo[]>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public FriendGroupInfo getFriendGroup(String id) throws MoeraNodeException {
        String location = "/people/friends/groups/%s".formatted(this.ue(id));
        TypeReference<FriendGroupInfo> returnTypeRef = new TypeReference<FriendGroupInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public FriendGroupInfo createFriendGroup(FriendGroupDescription friendGroup) throws MoeraNodeException {
        String location = "/people/friends/groups";
        TypeReference<FriendGroupInfo> returnTypeRef = new TypeReference<FriendGroupInfo>(){};
        return this.call(location, null, "POST", (Object)friendGroup, returnTypeRef);
    }

    public FriendGroupInfo updateFriendGroup(String id, FriendGroupDescription friendGroup) throws MoeraNodeException {
        String location = "/people/friends/groups/%s".formatted(this.ue(id));
        TypeReference<FriendGroupInfo> returnTypeRef = new TypeReference<FriendGroupInfo>(){};
        return this.call(location, null, "PUT", (Object)friendGroup, returnTypeRef);
    }

    public Result deleteFriendGroup(String id) throws MoeraNodeException {
        String location = "/people/friends/groups/%s".formatted(this.ue(id));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public FriendInfo[] getFriends(String groupId) throws MoeraNodeException {
        String location = "/people/friends";
        QueryParam[] params = new QueryParam[]{QueryParam.of("groupId", groupId)};
        TypeReference<FriendInfo[]> returnTypeRef = new TypeReference<FriendInfo[]>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public FriendInfo getFriend(String name) throws MoeraNodeException {
        String location = "/people/friends/%s".formatted(this.ue(name));
        TypeReference<FriendInfo> returnTypeRef = new TypeReference<FriendInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public FriendInfo[] updateFriends(FriendDescription[] friends) throws MoeraNodeException {
        String location = "/people/friends";
        TypeReference<FriendInfo[]> returnTypeRef = new TypeReference<FriendInfo[]>(){};
        return this.call(location, null, "PUT", (Object)friends, returnTypeRef);
    }

    public FriendOfInfo[] getFriendOfs() throws MoeraNodeException {
        String location = "/people/friend-ofs";
        TypeReference<FriendOfInfo[]> returnTypeRef = new TypeReference<FriendOfInfo[]>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public FriendOfInfo getFriendOf(String name) throws MoeraNodeException {
        String location = "/people/friend-ofs/%s".formatted(this.ue(name));
        TypeReference<FriendOfInfo> returnTypeRef = new TypeReference<FriendOfInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public GrantInfo[] getAllGrants() throws MoeraNodeException {
        String location = "/grants";
        TypeReference<GrantInfo[]> returnTypeRef = new TypeReference<GrantInfo[]>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public GrantInfo getGrant(String nodeName) throws MoeraNodeException {
        String location = "/grants/%s".formatted(this.ue(nodeName));
        TypeReference<GrantInfo> returnTypeRef = new TypeReference<GrantInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public GrantInfo grantOrRevoke(String nodeName, GrantChange change) throws MoeraNodeException {
        String location = "/grants/%s".formatted(this.ue(nodeName));
        TypeReference<GrantInfo> returnTypeRef = new TypeReference<GrantInfo>(){};
        return this.call(location, null, "PUT", (Object)change, returnTypeRef);
    }

    public Result revokeAll(String nodeName) throws MoeraNodeException {
        String location = "/grants/%s".formatted(this.ue(nodeName));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public PrivateMediaFileInfo uploadAdminMedia(Path body, String contentType) throws MoeraNodeException {
        String location = "/media/private";
        TypeReference<PrivateMediaFileInfo> returnTypeRef = new TypeReference<PrivateMediaFileInfo>(){};
        return this.call(location, null, "POST", body, contentType, returnTypeRef);
    }

    public PrivateMediaFileInfo uploadPrivateMedia(String clientName, Path body, String contentType) throws MoeraNodeException {
        String location = "/media/private/%s".formatted(this.ue(clientName));
        TypeReference<PrivateMediaFileInfo> returnTypeRef = new TypeReference<PrivateMediaFileInfo>(){};
        return this.call(location, null, "POST", body, contentType, returnTypeRef);
    }

    public void getPrivateMedia(String id, Integer width, Boolean download, NodeApiClient.ResponseConsumer responseConsumer) throws MoeraNodeException {
        String location = "/media/private/%s/data".formatted(this.ue(id));
        QueryParam[] params = new QueryParam[]{QueryParam.of("width", width), QueryParam.of("download", download)};
        this.call(location, params, "GET", null, responseConsumer);
    }

    public PrivateMediaFileInfo getPrivateMediaInfo(String id) throws MoeraNodeException {
        String location = "/media/private/%s/info".formatted(this.ue(id));
        TypeReference<PrivateMediaFileInfo> returnTypeRef = new TypeReference<PrivateMediaFileInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public EntryInfo[] getPrivateMediaParentEntry(String id) throws MoeraNodeException {
        String location = "/media/private/%s/parent".formatted(this.ue(id));
        TypeReference<EntryInfo[]> returnTypeRef = new TypeReference<EntryInfo[]>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public PublicMediaFileInfo uploadPublicMedia(Path body, String contentType) throws MoeraNodeException {
        String location = "/media/public";
        TypeReference<PublicMediaFileInfo> returnTypeRef = new TypeReference<PublicMediaFileInfo>(){};
        return this.call(location, null, "POST", body, contentType, returnTypeRef);
    }

    public void getPublicMedia(String id, Integer width, Boolean download, NodeApiClient.ResponseConsumer responseConsumer) throws MoeraNodeException {
        String location = "/media/public/%s/data".formatted(this.ue(id));
        QueryParam[] params = new QueryParam[]{QueryParam.of("width", width), QueryParam.of("download", download)};
        this.call(location, params, "GET", null, responseConsumer);
    }

    public PublicMediaFileInfo getPublicMediaInfo(String id) throws MoeraNodeException {
        String location = "/media/public/%s/info".formatted(this.ue(id));
        TypeReference<PublicMediaFileInfo> returnTypeRef = new TypeReference<PublicMediaFileInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public NodeNameInfo getNodeName() throws MoeraNodeException {
        String location = "/node-name";
        TypeReference<NodeNameInfo> returnTypeRef = new TypeReference<NodeNameInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public RegisteredNameSecret createNodeName(NameToRegister nameToRegister) throws MoeraNodeException {
        String location = "/node-name";
        TypeReference<RegisteredNameSecret> returnTypeRef = new TypeReference<RegisteredNameSecret>(){};
        return this.call(location, null, "POST", (Object)nameToRegister, returnTypeRef);
    }

    public Result updateNodeName(RegisteredNameSecret secret) throws MoeraNodeException {
        String location = "/node-name";
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "PUT", (Object)secret, returnTypeRef);
    }

    public Result deleteNodeName() throws MoeraNodeException {
        String location = "/node-name";
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public KeyMnemonic getStoredMnemonic() throws MoeraNodeException {
        String location = "/node-name/mnemonic";
        TypeReference<KeyMnemonic> returnTypeRef = new TypeReference<KeyMnemonic>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public Result storeMnemonic(KeyMnemonic mnemonic) throws MoeraNodeException {
        String location = "/node-name/mnemonic";
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "POST", (Object)mnemonic, returnTypeRef);
    }

    public Result deleteStoredMnemonic() throws MoeraNodeException {
        String location = "/node-name/mnemonic";
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public Result sendNotification(NotificationPacket packet) throws MoeraNodeException {
        String location = "/notifications";
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "POST", (Object)packet, returnTypeRef);
    }

    public PeopleGeneralInfo getPeopleGeneral() throws MoeraNodeException {
        String location = "/people";
        TypeReference<PeopleGeneralInfo> returnTypeRef = new TypeReference<PeopleGeneralInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public PluginInfo registerPlugin(PluginDescription plugin) throws MoeraNodeException {
        String location = "/plugins";
        TypeReference<PluginInfo> returnTypeRef = new TypeReference<PluginInfo>(){};
        return this.call(location, null, "POST", (Object)plugin, returnTypeRef);
    }

    public PluginInfo[] getPlugins() throws MoeraNodeException {
        String location = "/plugins";
        TypeReference<PluginInfo[]> returnTypeRef = new TypeReference<PluginInfo[]>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public PluginInfo getPlugin(String pluginName) throws MoeraNodeException {
        String location = "/plugins/%s".formatted(this.ue(pluginName));
        TypeReference<PluginInfo> returnTypeRef = new TypeReference<PluginInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public Result unregisterPlugin(String pluginName) throws MoeraNodeException {
        String location = "/plugins/%s".formatted(this.ue(pluginName));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public PostingInfo createPosting(PostingText posting) throws MoeraNodeException {
        String location = "/postings";
        TypeReference<PostingInfo> returnTypeRef = new TypeReference<PostingInfo>(){};
        return this.call(location, null, "POST", (Object)posting, returnTypeRef);
    }

    public PostingInfo updatePosting(String id, PostingText posting) throws MoeraNodeException {
        String location = "/postings/%s".formatted(this.ue(id));
        TypeReference<PostingInfo> returnTypeRef = new TypeReference<PostingInfo>(){};
        return this.call(location, null, "PUT", (Object)posting, returnTypeRef);
    }

    public PostingInfo getPosting(String id, boolean withSource) throws MoeraNodeException {
        String include = this.commaSeparatedFlags(QueryParam.of("source", withSource));
        String location = "/postings/%s".formatted(this.ue(id));
        QueryParam[] params = new QueryParam[]{QueryParam.of("include", include)};
        TypeReference<PostingInfo> returnTypeRef = new TypeReference<PostingInfo>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public Result deletePosting(String id) throws MoeraNodeException {
        String location = "/postings/%s".formatted(this.ue(id));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public PostingInfo[] getPostingsAttachedToPosting(String id) throws MoeraNodeException {
        String location = "/postings/%s/attached".formatted(this.ue(id));
        TypeReference<PostingInfo[]> returnTypeRef = new TypeReference<PostingInfo[]>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public PostingRevisionInfo[] getPostingRevisions(String postingId, Integer limit) throws MoeraNodeException {
        String location = "/postings/%s/revisions".formatted(this.ue(postingId));
        QueryParam[] params = new QueryParam[]{QueryParam.of("limit", limit)};
        TypeReference<PostingRevisionInfo[]> returnTypeRef = new TypeReference<PostingRevisionInfo[]>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public PostingRevisionInfo getPostingRevision(String postingId, String id) throws MoeraNodeException {
        String location = "/postings/%s/revisions/%s".formatted(this.ue(postingId), this.ue(id));
        TypeReference<PostingRevisionInfo> returnTypeRef = new TypeReference<PostingRevisionInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public PostingRevisionInfo restorePostingRevision(String postingId, String id) throws MoeraNodeException {
        String location = "/postings/%s/revisions/%s/restore".formatted(this.ue(postingId), this.ue(id));
        TypeReference<PostingRevisionInfo> returnTypeRef = new TypeReference<PostingRevisionInfo>(){};
        return this.call(location, null, "POST", null, returnTypeRef);
    }

    public ReactionCreated createPostingReaction(String postingId, ReactionDescription reaction) throws MoeraNodeException {
        String location = "/postings/%s/reactions".formatted(this.ue(postingId));
        TypeReference<ReactionCreated> returnTypeRef = new TypeReference<ReactionCreated>(){};
        return this.call(location, null, "POST", (Object)reaction, returnTypeRef);
    }

    public ReactionsSliceInfo getPostingReactionsSlice(String postingId, Boolean negative, Integer emoji, Long before, Integer limit) throws MoeraNodeException {
        String location = "/postings/%s/reactions".formatted(this.ue(postingId));
        QueryParam[] params = new QueryParam[]{QueryParam.of("negative", negative), QueryParam.of("emoji", emoji), QueryParam.of("before", before), QueryParam.of("limit", limit)};
        TypeReference<ReactionsSliceInfo> returnTypeRef = new TypeReference<ReactionsSliceInfo>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public ReactionInfo updatePostingReaction(String postingId, String ownerName, ReactionOverride reaction) throws MoeraNodeException {
        String location = "/postings/%s/reactions/%s".formatted(this.ue(postingId), this.ue(ownerName));
        TypeReference<ReactionInfo> returnTypeRef = new TypeReference<ReactionInfo>(){};
        return this.call(location, null, "PUT", (Object)reaction, returnTypeRef);
    }

    public ReactionInfo getPostingReaction(String postingId, String ownerName) throws MoeraNodeException {
        String location = "/postings/%s/reactions/%s".formatted(this.ue(postingId), this.ue(ownerName));
        TypeReference<ReactionInfo> returnTypeRef = new TypeReference<ReactionInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public Result deleteAllPostingReactions(String postingId) throws MoeraNodeException {
        String location = "/postings/%s/reactions".formatted(this.ue(postingId));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public ReactionTotalsInfo deletePostingReaction(String postingId, String ownerName) throws MoeraNodeException {
        String location = "/postings/%s/reactions/%s".formatted(this.ue(postingId), this.ue(ownerName));
        TypeReference<ReactionTotalsInfo> returnTypeRef = new TypeReference<ReactionTotalsInfo>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public ReactionInfo[] searchPostingReactions(ReactionsFilter filter) throws MoeraNodeException {
        String location = "/postings/reactions/search";
        TypeReference<ReactionInfo[]> returnTypeRef = new TypeReference<ReactionInfo[]>(){};
        return this.call(location, null, "POST", (Object)filter, returnTypeRef);
    }

    public ReactionTotalsInfo getPostingReactionTotals(String postingId) throws MoeraNodeException {
        String location = "/postings/%s/reaction-totals".formatted(this.ue(postingId));
        TypeReference<ReactionTotalsInfo> returnTypeRef = new TypeReference<ReactionTotalsInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public ReactionTotalsInfo[] searchPostingReactionTotals(ReactionTotalsFilter filter) throws MoeraNodeException {
        String location = "/postings/reaction-totals/search";
        TypeReference<ReactionTotalsInfo[]> returnTypeRef = new TypeReference<ReactionTotalsInfo[]>(){};
        return this.call(location, null, "POST", (Object)filter, returnTypeRef);
    }

    public ProfileInfo getProfile(boolean withSource) throws MoeraNodeException {
        String include = this.commaSeparatedFlags(QueryParam.of("source", withSource));
        String location = "/profile";
        QueryParam[] params = new QueryParam[]{QueryParam.of("include", include)};
        TypeReference<ProfileInfo> returnTypeRef = new TypeReference<ProfileInfo>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public ProfileInfo updateProfile(ProfileAttributes profile) throws MoeraNodeException {
        String location = "/profile";
        TypeReference<ProfileInfo> returnTypeRef = new TypeReference<ProfileInfo>(){};
        return this.call(location, null, "PUT", (Object)profile, returnTypeRef);
    }

    public DeleteNodeStatus getDeleteNodeRequestStatus() throws MoeraNodeException {
        String location = "/provider/delete-node";
        TypeReference<DeleteNodeStatus> returnTypeRef = new TypeReference<DeleteNodeStatus>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public DeleteNodeStatus sendDeleteNodeRequest(DeleteNodeText deleteNodeText) throws MoeraNodeException {
        String location = "/provider/delete-node";
        TypeReference<DeleteNodeStatus> returnTypeRef = new TypeReference<DeleteNodeStatus>(){};
        return this.call(location, null, "POST", (Object)deleteNodeText, returnTypeRef);
    }

    public DeleteNodeStatus cancelDeleteNodeRequest() throws MoeraNodeException {
        String location = "/provider/delete-node";
        TypeReference<DeleteNodeStatus> returnTypeRef = new TypeReference<DeleteNodeStatus>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public void proxyMedia(String url, NodeApiClient.ResponseConsumer responseConsumer) throws MoeraNodeException {
        String location = "/proxy/media";
        QueryParam[] params = new QueryParam[]{QueryParam.of("url", url)};
        this.call(location, params, "GET", null, responseConsumer);
    }

    public LinkPreviewInfo proxyLinkPreview(String url) throws MoeraNodeException {
        String location = "/proxy/link-preview";
        QueryParam[] params = new QueryParam[]{QueryParam.of("url", url)};
        TypeReference<LinkPreviewInfo> returnTypeRef = new TypeReference<LinkPreviewInfo>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public Result registerAtPushRelay(PushRelayClientAttributes attributes) throws MoeraNodeException {
        String location = "/push-relay";
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "POST", (Object)attributes, returnTypeRef);
    }

    public RecommendedPostingInfo[] getRecommendedPostings(String sheriff, Integer limit) throws MoeraNodeException {
        String location = "/recommendations/postings";
        QueryParam[] params = new QueryParam[]{QueryParam.of("sheriff", sheriff), QueryParam.of("limit", limit)};
        TypeReference<RecommendedPostingInfo[]> returnTypeRef = new TypeReference<RecommendedPostingInfo[]>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public RecommendedPostingInfo[] getRecommendedPostingsForReading(String sheriff, Integer limit) throws MoeraNodeException {
        String location = "/recommendations/postings/reading";
        QueryParam[] params = new QueryParam[]{QueryParam.of("sheriff", sheriff), QueryParam.of("limit", limit)};
        TypeReference<RecommendedPostingInfo[]> returnTypeRef = new TypeReference<RecommendedPostingInfo[]>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public RecommendedPostingInfo[] getRecommendedPostingsForCommenting(String sheriff, Integer limit) throws MoeraNodeException {
        String location = "/recommendations/postings/commenting";
        QueryParam[] params = new QueryParam[]{QueryParam.of("sheriff", sheriff), QueryParam.of("limit", limit)};
        TypeReference<RecommendedPostingInfo[]> returnTypeRef = new TypeReference<RecommendedPostingInfo[]>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public Result acceptRecommendedPosting(String nodeName, String postingId) throws MoeraNodeException {
        String location = "/recommendations/postings/accepted/%s/%s".formatted(this.ue(nodeName), this.ue(postingId));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "POST", null, returnTypeRef);
    }

    public Result rejectRecommendedPosting(String nodeName, String postingId) throws MoeraNodeException {
        String location = "/recommendations/postings/rejected/%s/%s".formatted(this.ue(nodeName), this.ue(postingId));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "POST", null, returnTypeRef);
    }

    public Result excludeNodeFromRecommendations(String nodeName) throws MoeraNodeException {
        String location = "/recommendations/nodes/excluded/%s".formatted(this.ue(nodeName));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "POST", null, returnTypeRef);
    }

    public Result allowNodeInRecommendations(String nodeName) throws MoeraNodeException {
        String location = "/recommendations/nodes/excluded/%s".formatted(this.ue(nodeName));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public Result askRemoteNode(String nodeName, AskDescription details) throws MoeraNodeException {
        String location = "/nodes/%s/ask".formatted(this.ue(nodeName));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "POST", (Object)details, returnTypeRef);
    }

    public Result createRemoteComment(String nodeName, String postingId, CommentSourceText comment) throws MoeraNodeException {
        String location = "/nodes/%s/postings/%s/comments".formatted(this.ue(nodeName), this.ue(postingId));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "POST", (Object)comment, returnTypeRef);
    }

    public Result updateRemoteComment(String nodeName, String postingId, String commentId, CommentSourceText comment) throws MoeraNodeException {
        String location = "/nodes/%s/postings/%s/comments/%s".formatted(this.ue(nodeName), this.ue(postingId), this.ue(commentId));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "PUT", (Object)comment, returnTypeRef);
    }

    public Result deleteRemoteComment(String nodeName, String postingId, String commentId) throws MoeraNodeException {
        String location = "/nodes/%s/postings/%s/comments/%s".formatted(this.ue(nodeName), this.ue(postingId), this.ue(commentId));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public AsyncOperationCreated verifyRemoteComment(String nodeName, String postingId, String commentId) throws MoeraNodeException {
        String location = "/nodes/%s/postings/%s/comments/%s/verify".formatted(this.ue(nodeName), this.ue(postingId), this.ue(commentId));
        TypeReference<AsyncOperationCreated> returnTypeRef = new TypeReference<AsyncOperationCreated>(){};
        return this.call(location, null, "POST", null, returnTypeRef);
    }

    public Result createRemoteCommentReaction(String nodeName, String postingId, String commentId, ReactionAttributes reaction) throws MoeraNodeException {
        String location = "/nodes/%s/postings/%s/comments/%s/reactions".formatted(this.ue(nodeName), this.ue(postingId), this.ue(commentId));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "POST", (Object)reaction, returnTypeRef);
    }

    public Result deleteRemoteCommentReaction(String nodeName, String postingId, String commentId) throws MoeraNodeException {
        String location = "/nodes/%s/postings/%s/comments/%s/reactions".formatted(this.ue(nodeName), this.ue(postingId), this.ue(commentId));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public AsyncOperationCreated verifyRemoteCommentReaction(String nodeName, String postingId, String commentId, String ownerName) throws MoeraNodeException {
        String location = "/nodes/%s/postings/%s/comments/%s/reactions/%s/verify".formatted(this.ue(nodeName), this.ue(postingId), this.ue(commentId), this.ue(ownerName));
        TypeReference<AsyncOperationCreated> returnTypeRef = new TypeReference<AsyncOperationCreated>(){};
        return this.call(location, null, "POST", null, returnTypeRef);
    }

    public Result createRemotePosting(String nodeName, PostingSourceText posting) throws MoeraNodeException {
        String location = "/nodes/%s/postings".formatted(this.ue(nodeName));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "POST", (Object)posting, returnTypeRef);
    }

    public Result updateRemotePosting(String nodeName, String postingId, PostingSourceText posting) throws MoeraNodeException {
        String location = "/nodes/%s/postings/%s".formatted(this.ue(nodeName), this.ue(postingId));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "PUT", (Object)posting, returnTypeRef);
    }

    public Result deleteRemotePosting(String nodeName, String postingId) throws MoeraNodeException {
        String location = "/nodes/%s/postings/%s".formatted(this.ue(nodeName), this.ue(postingId));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public AsyncOperationCreated verifyRemotePosting(String nodeName, String id) throws MoeraNodeException {
        String location = "/nodes/%s/postings/%s/verify".formatted(this.ue(nodeName), this.ue(id));
        TypeReference<AsyncOperationCreated> returnTypeRef = new TypeReference<AsyncOperationCreated>(){};
        return this.call(location, null, "POST", null, returnTypeRef);
    }

    public AsyncOperationCreated verifyRemotePostingRevision(String nodeName, String id, String revisionId) throws MoeraNodeException {
        String location = "/nodes/%s/postings/%s/revisions/%s/verify".formatted(this.ue(nodeName), this.ue(id), this.ue(revisionId));
        TypeReference<AsyncOperationCreated> returnTypeRef = new TypeReference<AsyncOperationCreated>(){};
        return this.call(location, null, "POST", null, returnTypeRef);
    }

    public Result createRemotePostingReaction(String nodeName, String postingId, ReactionAttributes reaction) throws MoeraNodeException {
        String location = "/nodes/%s/postings/%s/reactions".formatted(this.ue(nodeName), this.ue(postingId));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "POST", (Object)reaction, returnTypeRef);
    }

    public Result deleteRemotePostingReaction(String nodeName, String postingId) throws MoeraNodeException {
        String location = "/nodes/%s/postings/%s/reactions".formatted(this.ue(nodeName), this.ue(postingId));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public AsyncOperationCreated verifyRemotePostingReaction(String nodeName, String postingId, String ownerName) throws MoeraNodeException {
        String location = "/nodes/%s/postings/%s/reactions/%s/verify".formatted(this.ue(nodeName), this.ue(postingId), this.ue(ownerName));
        TypeReference<AsyncOperationCreated> returnTypeRef = new TypeReference<AsyncOperationCreated>(){};
        return this.call(location, null, "POST", null, returnTypeRef);
    }

    public Result createRemoteSheriffOrder(String nodeName, SheriffOrderAttributes sheriffOrder) throws MoeraNodeException {
        String location = "/nodes/%s/sheriff/orders".formatted(this.ue(nodeName));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "POST", (Object)sheriffOrder, returnTypeRef);
    }

    public SheriffOrderInfo getRemoteSheriffOrder(String nodeName, String id) throws MoeraNodeException {
        String location = "/nodes/%s/sheriff/orders/%s".formatted(this.ue(nodeName), this.ue(id));
        TypeReference<SheriffOrderInfo> returnTypeRef = new TypeReference<SheriffOrderInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public SearchNodePageInfo searchNodes(SearchNodeFilter filter) throws MoeraNodeException {
        String location = "/search/nodes";
        TypeReference<SearchNodePageInfo> returnTypeRef = new TypeReference<SearchNodePageInfo>(){};
        return this.call(location, null, "POST", (Object)filter, returnTypeRef);
    }

    public SearchNodeInfo[] searchNodeSuggestions(String query, String sheriff, Integer limit) throws MoeraNodeException {
        String location = "/search/nodes/suggestions";
        QueryParam[] params = new QueryParam[]{QueryParam.of("query", query), QueryParam.of("sheriff", sheriff), QueryParam.of("limit", limit)};
        TypeReference<SearchNodeInfo[]> returnTypeRef = new TypeReference<SearchNodeInfo[]>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public SearchHashtagSliceInfo searchEntriesByHashtag(SearchHashtagFilter filter) throws MoeraNodeException {
        String location = "/search/entries/by-hashtag";
        TypeReference<SearchHashtagSliceInfo> returnTypeRef = new TypeReference<SearchHashtagSliceInfo>(){};
        return this.call(location, null, "POST", (Object)filter, returnTypeRef);
    }

    public SearchTextPageInfo searchEntriesByText(SearchTextFilter filter) throws MoeraNodeException {
        String location = "/search/entries/by-text";
        TypeReference<SearchTextPageInfo> returnTypeRef = new TypeReference<SearchTextPageInfo>(){};
        return this.call(location, null, "POST", (Object)filter, returnTypeRef);
    }

    public Result updateSettings(SettingInfo[] settings) throws MoeraNodeException {
        String location = "/settings";
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "PUT", (Object)settings, returnTypeRef);
    }

    public SettingInfo[] getClientSettings(String prefix) throws MoeraNodeException {
        String location = "/settings/client";
        QueryParam[] params = new QueryParam[]{QueryParam.of("prefix", prefix)};
        TypeReference<SettingInfo[]> returnTypeRef = new TypeReference<SettingInfo[]>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public SettingInfo[] getNodeSettings(String prefix) throws MoeraNodeException {
        String location = "/settings/node";
        QueryParam[] params = new QueryParam[]{QueryParam.of("prefix", prefix)};
        TypeReference<SettingInfo[]> returnTypeRef = new TypeReference<SettingInfo[]>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public SettingMetaInfo[] getNodeSettingsMetadata(String prefix) throws MoeraNodeException {
        String location = "/settings/node/metadata";
        QueryParam[] params = new QueryParam[]{QueryParam.of("prefix", prefix)};
        TypeReference<SettingMetaInfo[]> returnTypeRef = new TypeReference<SettingMetaInfo[]>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public Result updateNodeSettingsMetadata(SettingMetaAttributes[] metadata) throws MoeraNodeException {
        String location = "/settings/node/metadata";
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "PUT", (Object)metadata, returnTypeRef);
    }

    public SheriffComplaintGroupsSliceInfo getSheriffComplaintGroupsSlice(Long after, Long before, Integer limit, SheriffComplaintStatus status) throws MoeraNodeException {
        String location = "/sheriff/complaints/groups";
        QueryParam[] params = new QueryParam[]{QueryParam.of("after", after), QueryParam.of("before", before), QueryParam.of("limit", limit), QueryParam.of("status", (Object)status)};
        TypeReference<SheriffComplaintGroupsSliceInfo> returnTypeRef = new TypeReference<SheriffComplaintGroupsSliceInfo>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public SheriffComplaintGroupInfo getSheriffComplaintGroup(String id) throws MoeraNodeException {
        String location = "/sheriff/complaints/groups/%s".formatted(this.ue(id));
        TypeReference<SheriffComplaintGroupInfo> returnTypeRef = new TypeReference<SheriffComplaintGroupInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public SheriffComplaintInfo[] getSheriffComplaintsByGroup(String id) throws MoeraNodeException {
        String location = "/sheriff/complaints/groups/%s/complaints".formatted(this.ue(id));
        TypeReference<SheriffComplaintInfo[]> returnTypeRef = new TypeReference<SheriffComplaintInfo[]>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public SheriffComplaintGroupInfo updateSheriffComplaintGroup(String id, SheriffComplaintDecisionText decision) throws MoeraNodeException {
        String location = "/sheriff/complaints/groups/%s".formatted(this.ue(id));
        TypeReference<SheriffComplaintGroupInfo> returnTypeRef = new TypeReference<SheriffComplaintGroupInfo>(){};
        return this.call(location, null, "PUT", (Object)decision, returnTypeRef);
    }

    public SheriffComplaintInfo createSheriffComplaint(SheriffComplaintText complaint) throws MoeraNodeException {
        String location = "/sheriff/complaints";
        TypeReference<SheriffComplaintInfo> returnTypeRef = new TypeReference<SheriffComplaintInfo>(){};
        return this.call(location, null, "POST", (Object)complaint, returnTypeRef);
    }

    public Result createSheriffOrder(SheriffOrderDetails sheriffOrder) throws MoeraNodeException {
        String location = "/sheriff/orders";
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "POST", (Object)sheriffOrder, returnTypeRef);
    }

    public StoryInfo getStory(String id) throws MoeraNodeException {
        String location = "/stories/%s".formatted(this.ue(id));
        TypeReference<StoryInfo> returnTypeRef = new TypeReference<StoryInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public StoryInfo updateStory(String id, StoryAttributes story) throws MoeraNodeException {
        String location = "/stories/%s".formatted(this.ue(id));
        TypeReference<StoryInfo> returnTypeRef = new TypeReference<StoryInfo>(){};
        return this.call(location, null, "PUT", (Object)story, returnTypeRef);
    }

    public Result deleteStory(String id) throws MoeraNodeException {
        String location = "/stories/%s".formatted(this.ue(id));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public SubscriberInfo[] getSubscribers(String nodeName, SubscriptionType type, String feedName, String entryId) throws MoeraNodeException {
        String location = "/people/subscribers";
        QueryParam[] params = new QueryParam[]{QueryParam.of("nodeName", nodeName), QueryParam.of("type", (Object)type), QueryParam.of("feedName", feedName), QueryParam.of("entryId", entryId)};
        TypeReference<SubscriberInfo[]> returnTypeRef = new TypeReference<SubscriberInfo[]>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public SubscriberInfo createSubscriber(SubscriberDescription subscriber) throws MoeraNodeException {
        String location = "/people/subscribers";
        TypeReference<SubscriberInfo> returnTypeRef = new TypeReference<SubscriberInfo>(){};
        return this.call(location, null, "POST", (Object)subscriber, returnTypeRef);
    }

    public SubscriberInfo getSubscriber(String id) throws MoeraNodeException {
        String location = "/people/subscribers/%s".formatted(this.ue(id));
        TypeReference<SubscriberInfo> returnTypeRef = new TypeReference<SubscriberInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public SubscriberInfo updateSubscriber(String id, SubscriberOverride subscriber) throws MoeraNodeException {
        String location = "/people/subscribers/%s".formatted(this.ue(id));
        TypeReference<SubscriberInfo> returnTypeRef = new TypeReference<SubscriberInfo>(){};
        return this.call(location, null, "PUT", (Object)subscriber, returnTypeRef);
    }

    public ContactInfo deleteSubscriber(String id) throws MoeraNodeException {
        String location = "/people/subscribers/%s".formatted(this.ue(id));
        TypeReference<ContactInfo> returnTypeRef = new TypeReference<ContactInfo>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public SubscriptionInfo[] getSubscriptions(String nodeName, SubscriptionType type) throws MoeraNodeException {
        String location = "/people/subscriptions";
        QueryParam[] params = new QueryParam[]{QueryParam.of("nodeName", nodeName), QueryParam.of("type", (Object)type)};
        TypeReference<SubscriptionInfo[]> returnTypeRef = new TypeReference<SubscriptionInfo[]>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public SubscriptionInfo createSubscription(SubscriptionDescription subscription) throws MoeraNodeException {
        String location = "/people/subscriptions";
        TypeReference<SubscriptionInfo> returnTypeRef = new TypeReference<SubscriptionInfo>(){};
        return this.call(location, null, "POST", (Object)subscription, returnTypeRef);
    }

    public SubscriptionInfo updateSubscription(String id, SubscriptionOverride subscription) throws MoeraNodeException {
        String location = "/people/subscriptions/%s".formatted(this.ue(id));
        TypeReference<SubscriptionInfo> returnTypeRef = new TypeReference<SubscriptionInfo>(){};
        return this.call(location, null, "PUT", (Object)subscription, returnTypeRef);
    }

    public ContactInfo deleteSubscription(String id) throws MoeraNodeException {
        String location = "/people/subscriptions/%s".formatted(this.ue(id));
        TypeReference<ContactInfo> returnTypeRef = new TypeReference<ContactInfo>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public SubscriptionInfo[] searchSubscriptions(SubscriptionFilter filter) throws MoeraNodeException {
        String location = "/people/subscriptions/search";
        TypeReference<SubscriptionInfo[]> returnTypeRef = new TypeReference<SubscriptionInfo[]>(){};
        return this.call(location, null, "POST", (Object)filter, returnTypeRef);
    }

    public TokenInfo[] getTokens() throws MoeraNodeException {
        String location = "/tokens";
        TypeReference<TokenInfo[]> returnTypeRef = new TypeReference<TokenInfo[]>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public TokenInfo createToken(TokenAttributes token) throws MoeraNodeException {
        String location = "/tokens";
        TypeReference<TokenInfo> returnTypeRef = new TypeReference<TokenInfo>(){};
        return this.call(location, null, "POST", (Object)token, returnTypeRef);
    }

    public TokenInfo getTokenInfo(String id) throws MoeraNodeException {
        String location = "/tokens/%s".formatted(this.ue(id));
        TypeReference<TokenInfo> returnTypeRef = new TypeReference<TokenInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public TokenInfo updateToken(String id, TokenUpdate update) throws MoeraNodeException {
        String location = "/tokens/%s".formatted(this.ue(id));
        TypeReference<TokenInfo> returnTypeRef = new TypeReference<TokenInfo>(){};
        return this.call(location, null, "PUT", (Object)update, returnTypeRef);
    }

    public Result deleteToken(String id) throws MoeraNodeException {
        String location = "/tokens/%s".formatted(this.ue(id));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public UserListInfo getUserListGeneral(String name) throws MoeraNodeException {
        String location = "/user-lists/%s".formatted(this.ue(name));
        TypeReference<UserListInfo> returnTypeRef = new TypeReference<UserListInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public UserListSliceInfo getUserListSlice(String name, Long after, Long before, Integer limit) throws MoeraNodeException {
        String location = "/user-lists/%s/items".formatted(this.ue(name));
        QueryParam[] params = new QueryParam[]{QueryParam.of("after", after), QueryParam.of("before", before), QueryParam.of("limit", limit)};
        TypeReference<UserListSliceInfo> returnTypeRef = new TypeReference<UserListSliceInfo>(){};
        return this.call(location, params, "GET", null, returnTypeRef);
    }

    public UserListItemInfo getUserListItem(String name, String nodeName) throws MoeraNodeException {
        String location = "/user-lists/%s/items/%s".formatted(this.ue(name), this.ue(nodeName));
        TypeReference<UserListItemInfo> returnTypeRef = new TypeReference<UserListItemInfo>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }

    public UserListItemInfo createUserListItem(String name, UserListItemAttributes item) throws MoeraNodeException {
        String location = "/user-lists/%s/items".formatted(this.ue(name));
        TypeReference<UserListItemInfo> returnTypeRef = new TypeReference<UserListItemInfo>(){};
        return this.call(location, null, "POST", (Object)item, returnTypeRef);
    }

    public Result deleteUserListItem(String name, String nodeName) throws MoeraNodeException {
        String location = "/user-lists/%s/items/%s".formatted(this.ue(name), this.ue(nodeName));
        TypeReference<Result> returnTypeRef = new TypeReference<Result>(){};
        return this.call(location, null, "DELETE", null, returnTypeRef);
    }

    public WhoAmI whoAmI() throws MoeraNodeException {
        String location = "/whoami";
        TypeReference<WhoAmI> returnTypeRef = new TypeReference<WhoAmI>(){};
        return this.call(location, null, "GET", null, returnTypeRef);
    }
}

