/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.exception;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.moera.lib.node.exception.MoeraNodeException;
import org.moera.lib.node.types.Result;
import org.moera.lib.util.LogUtil;

public class MoeraNodeApiException
extends MoeraNodeException {
    protected int status;
    protected String errorCode;

    protected MoeraNodeApiException(String message) {
        super(message);
    }

    public MoeraNodeApiException(int status, String errorCode, String errorMessage) {
        super(MoeraNodeApiException.getErrorTypeMessage(status) + ": (%s %s)".formatted(LogUtil.format(errorCode), LogUtil.format(errorMessage)));
        this.status = status;
        this.errorCode = errorCode;
    }

    public MoeraNodeApiException(int status, Result result) {
        this(status, result != null ? result.getErrorCode() : null, result != null ? result.getMessage() : null);
    }

    public MoeraNodeApiException(int status, String body) {
        this(status, MoeraNodeApiException.parseResult(body));
    }

    private static String getErrorTypeMessage(int status) {
        return switch (status) {
            case 400 -> "Validation failed";
            case 404 -> "Object not found";
            case 409 -> "Operation failed";
            default -> "Error status returned: %d".formatted(status);
        };
    }

    protected static Result parseResult(String body) {
        if (body == null) {
            return null;
        }
        try {
            return (Result)new ObjectMapper().readValue(body, Result.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String getErrorCode() {
        return this.errorCode;
    }
}

