/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum BlockedOperation {
    REACTION,
    COMMENT,
    POSTING,
    VISIBILITY,
    INSTANT;


    @JsonValue
    public String getValue() {
        return this.name().toLowerCase().replace("__", "/").replace('_', '-');
    }

    public static String toValue(BlockedOperation type) {
        return type != null ? type.getValue() : null;
    }

    public static BlockedOperation forValue(String value) {
        try {
            return BlockedOperation.parse(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String toString() {
        return this.getValue();
    }

    @JsonCreator
    public static BlockedOperation parse(String value) {
        return BlockedOperation.valueOf(value.toUpperCase().replace('-', '_').replace("/", "__"));
    }
}

