/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.AcceptedReactions;
import org.moera.lib.node.types.AvatarDescription;
import org.moera.lib.node.types.BodyFormat;
import org.moera.lib.node.types.CommentOperations;
import org.moera.lib.node.types.ReactionOperations;
import org.moera.lib.node.types.SourceFormat;
import org.moera.lib.node.types.Structure;
import org.moera.lib.node.types.body.Body;
import org.moera.lib.node.types.validate.ValidationUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CommentText
extends Structure
implements Cloneable {
    private String ownerName;
    private String ownerFullName;
    private String ownerGender;
    private AvatarDescription ownerAvatar;
    private Body bodyPreview;
    private Body bodySrc;
    private SourceFormat bodySrcFormat;
    private Body body;
    private BodyFormat bodyFormat;
    private List<String> media;
    private Long createdAt;
    private AcceptedReactions acceptedReactions;
    private String repliedToId;
    private byte[] signature;
    private Short signatureVersion;
    private CommentOperations operations;
    private ReactionOperations reactionOperations;
    private CommentOperations seniorOperations;

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getOwnerFullName() {
        return this.ownerFullName;
    }

    public void setOwnerFullName(String ownerFullName) {
        this.ownerFullName = ownerFullName;
    }

    public String getOwnerGender() {
        return this.ownerGender;
    }

    public void setOwnerGender(String ownerGender) {
        this.ownerGender = ownerGender;
    }

    public AvatarDescription getOwnerAvatar() {
        return this.ownerAvatar;
    }

    public void setOwnerAvatar(AvatarDescription ownerAvatar) {
        this.ownerAvatar = ownerAvatar;
    }

    public Body getBodyPreview() {
        return this.bodyPreview;
    }

    public void setBodyPreview(Body bodyPreview) {
        this.bodyPreview = bodyPreview;
    }

    public Body getBodySrc() {
        return this.bodySrc;
    }

    public void setBodySrc(Body bodySrc) {
        this.bodySrc = bodySrc;
    }

    public SourceFormat getBodySrcFormat() {
        return this.bodySrcFormat;
    }

    public void setBodySrcFormat(SourceFormat bodySrcFormat) {
        this.bodySrcFormat = bodySrcFormat;
    }

    public Body getBody() {
        return this.body;
    }

    public void setBody(Body body) {
        this.body = body;
    }

    public BodyFormat getBodyFormat() {
        return this.bodyFormat;
    }

    public void setBodyFormat(BodyFormat bodyFormat) {
        this.bodyFormat = bodyFormat;
    }

    public List<String> getMedia() {
        return this.media;
    }

    public void setMedia(List<String> media) {
        this.media = media;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public AcceptedReactions getAcceptedReactions() {
        return this.acceptedReactions;
    }

    public void setAcceptedReactions(AcceptedReactions acceptedReactions) {
        this.acceptedReactions = acceptedReactions;
    }

    public String getRepliedToId() {
        return this.repliedToId;
    }

    public void setRepliedToId(String repliedToId) {
        this.repliedToId = repliedToId;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public Short getSignatureVersion() {
        return this.signatureVersion;
    }

    public void setSignatureVersion(Short signatureVersion) {
        this.signatureVersion = signatureVersion;
    }

    public CommentOperations getOperations() {
        return this.operations;
    }

    public void setOperations(CommentOperations operations) {
        this.operations = operations;
    }

    public ReactionOperations getReactionOperations() {
        return this.reactionOperations;
    }

    public void setReactionOperations(ReactionOperations reactionOperations) {
        this.reactionOperations = reactionOperations;
    }

    public CommentOperations getSeniorOperations() {
        return this.seniorOperations;
    }

    public void setSeniorOperations(CommentOperations seniorOperations) {
        this.seniorOperations = seniorOperations;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.maxSize(this.ownerName, 63, "comment.owner-name.wrong-size");
        ValidationUtil.maxSize(this.ownerFullName, 96, "comment.owner-full-name.wrong-size");
        ValidationUtil.maxSize(this.ownerGender, 31, "comment.owner-gender.wrong-size");
        if (this.acceptedReactions != null) {
            this.acceptedReactions.validate();
        }
    }

    public CommentText clone() {
        try {
            return (CommentText)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Must implement Cloneable", e);
        }
    }
}

