/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.SearchEntryType;
import org.moera.lib.node.types.Structure;
import org.moera.lib.node.types.validate.ValidationUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchTextFilter
extends Structure
implements Cloneable {
    private SearchEntryType entryType;
    private String text;
    private List<String> hashtags;
    private String publisherName;
    private Boolean inNewsfeed;
    private List<String> owners;
    private List<String> repliedTo;
    private Integer minImageCount;
    private Integer maxImageCount;
    private Boolean videoPresent;
    private Long createdAfter;
    private Long createdBefore;
    private String sheriffName;
    private Integer page;
    private Integer limit;

    public SearchEntryType getEntryType() {
        return this.entryType;
    }

    public void setEntryType(SearchEntryType entryType) {
        this.entryType = entryType;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<String> getHashtags() {
        return this.hashtags;
    }

    public void setHashtags(List<String> hashtags) {
        this.hashtags = hashtags;
    }

    public String getPublisherName() {
        return this.publisherName;
    }

    public void setPublisherName(String publisherName) {
        this.publisherName = publisherName;
    }

    public Boolean getInNewsfeed() {
        return this.inNewsfeed;
    }

    public void setInNewsfeed(Boolean inNewsfeed) {
        this.inNewsfeed = inNewsfeed;
    }

    public List<String> getOwners() {
        return this.owners;
    }

    public void setOwners(List<String> owners) {
        this.owners = owners;
    }

    public List<String> getRepliedTo() {
        return this.repliedTo;
    }

    public void setRepliedTo(List<String> repliedTo) {
        this.repliedTo = repliedTo;
    }

    public Integer getMinImageCount() {
        return this.minImageCount;
    }

    public void setMinImageCount(Integer minImageCount) {
        this.minImageCount = minImageCount;
    }

    public Integer getMaxImageCount() {
        return this.maxImageCount;
    }

    public void setMaxImageCount(Integer maxImageCount) {
        this.maxImageCount = maxImageCount;
    }

    public Boolean getVideoPresent() {
        return this.videoPresent;
    }

    public void setVideoPresent(Boolean videoPresent) {
        this.videoPresent = videoPresent;
    }

    public Long getCreatedAfter() {
        return this.createdAfter;
    }

    public void setCreatedAfter(Long createdAfter) {
        this.createdAfter = createdAfter;
    }

    public Long getCreatedBefore() {
        return this.createdBefore;
    }

    public void setCreatedBefore(Long createdBefore) {
        this.createdBefore = createdBefore;
    }

    public String getSheriffName() {
        return this.sheriffName;
    }

    public void setSheriffName(String sheriffName) {
        this.sheriffName = sheriffName;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.notBlank(this.text, "search.text.blank");
        ValidationUtil.maxItems(this.hashtags, 16, "search.hashtags.too-many");
        ValidationUtil.maxItems(this.owners, 16, "search.owners.too-many");
        ValidationUtil.maxItems(this.repliedTo, 16, "search.replied-to.too-many");
        ValidationUtil.minValue(this.minImageCount, 0, "search.min-image-count.invalid");
        ValidationUtil.minValue(this.maxImageCount, 0, "search.max-image-count.invalid");
        ValidationUtil.minValue(this.page, 0, "page.invalid");
        ValidationUtil.minValue(this.limit, 0, "limit.invalid");
    }

    public SearchTextFilter clone() {
        try {
            return (SearchTextFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Must implement Cloneable", e);
        }
    }
}

