/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.AvatarImage;
import org.moera.lib.node.types.notifications.LogPair;
import org.moera.lib.node.types.notifications.Notification;
import org.moera.lib.node.types.notifications.NotificationType;
import org.moera.lib.node.types.validate.ValidationUtil;
import org.moera.lib.util.LogUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CommentReactionAddedNotification
extends Notification {
    private String postingId;
    private String commentId;
    private String ownerName;
    private String ownerFullName;
    private String ownerGender;
    private AvatarImage ownerAvatar;
    private boolean negative;
    private int emoji;
    private String postingNodeName;
    private String postingFullName;
    private String postingGender;
    private AvatarImage postingAvatar;
    private String postingHeading;
    private String commentHeading;

    public CommentReactionAddedNotification() {
        super(NotificationType.COMMENT_REACTION_ADDED);
    }

    public String getPostingId() {
        return this.postingId;
    }

    public void setPostingId(String postingId) {
        this.postingId = postingId;
    }

    public String getCommentId() {
        return this.commentId;
    }

    public void setCommentId(String commentId) {
        this.commentId = commentId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getOwnerFullName() {
        return this.ownerFullName;
    }

    public void setOwnerFullName(String ownerFullName) {
        this.ownerFullName = ownerFullName;
    }

    public String getOwnerGender() {
        return this.ownerGender;
    }

    public void setOwnerGender(String ownerGender) {
        this.ownerGender = ownerGender;
    }

    public AvatarImage getOwnerAvatar() {
        return this.ownerAvatar;
    }

    public void setOwnerAvatar(AvatarImage ownerAvatar) {
        this.ownerAvatar = ownerAvatar;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void setNegative(boolean negative) {
        this.negative = negative;
    }

    public int getEmoji() {
        return this.emoji;
    }

    public void setEmoji(int emoji) {
        this.emoji = emoji;
    }

    public String getPostingNodeName() {
        return this.postingNodeName;
    }

    public void setPostingNodeName(String postingNodeName) {
        this.postingNodeName = postingNodeName;
    }

    public String getPostingFullName() {
        return this.postingFullName;
    }

    public void setPostingFullName(String postingFullName) {
        this.postingFullName = postingFullName;
    }

    public String getPostingGender() {
        return this.postingGender;
    }

    public void setPostingGender(String postingGender) {
        this.postingGender = postingGender;
    }

    public AvatarImage getPostingAvatar() {
        return this.postingAvatar;
    }

    public void setPostingAvatar(AvatarImage postingAvatar) {
        this.postingAvatar = postingAvatar;
    }

    public String getPostingHeading() {
        return this.postingHeading;
    }

    public void setPostingHeading(String postingHeading) {
        this.postingHeading = postingHeading;
    }

    public String getCommentHeading() {
        return this.commentHeading;
    }

    public void setCommentHeading(String commentHeading) {
        this.commentHeading = commentHeading;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.maxSize(this.postingId, 40, "reaction.posting-id.wrong-size");
        ValidationUtil.maxSize(this.commentId, 40, "reaction.comment-id.wrong-size");
        ValidationUtil.maxSize(this.ownerName, 63, "reaction.owner-name.wrong-size");
        ValidationUtil.maxSize(this.ownerFullName, 96, "reaction.owner-full-name.wrong-size");
        ValidationUtil.maxSize(this.ownerGender, 31, "reaction.owner-gender.wrong-size");
        ValidationUtil.maxSize(this.postingNodeName, 63, "reaction.posting-node-name.wrong-size");
        ValidationUtil.maxSize(this.postingFullName, 96, "reaction.posting-full-name.wrong-size");
        ValidationUtil.maxSize(this.postingGender, 31, "reaction.posting-gender.wrong-size");
        ValidationUtil.maxSize(this.postingHeading, 255, "reaction.posting-heading.wrong-size");
        ValidationUtil.maxSize(this.commentHeading, 255, "reaction.comment-heading.wrong-size");
    }

    @Override
    public void logParameters(List<LogPair> parameters) {
        super.logParameters(parameters);
        parameters.add(LogPair.of("postingId", LogUtil.format(this.postingId)));
        parameters.add(LogPair.of("commentId", LogUtil.format(this.commentId)));
        parameters.add(LogPair.of("ownerName", LogUtil.format(this.ownerName)));
        parameters.add(LogPair.of("negative", LogUtil.format(this.negative)));
        parameters.add(LogPair.of("emoji", LogUtil.format(this.emoji)));
        parameters.add(LogPair.of("postingNodeName", LogUtil.format(this.postingNodeName)));
    }
}

