/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.AvatarImage;
import org.moera.lib.node.types.notifications.LogPair;
import org.moera.lib.node.types.notifications.Notification;
import org.moera.lib.node.types.notifications.NotificationType;
import org.moera.lib.node.types.validate.ValidationUtil;
import org.moera.lib.util.LogUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CommentReactionDeletedNotification
extends Notification {
    private String postingId;
    private String commentId;
    private String ownerName;
    private String ownerFullName;
    private String ownerGender;
    private AvatarImage ownerAvatar;
    private boolean negative;

    public CommentReactionDeletedNotification() {
        super(NotificationType.COMMENT_REACTION_DELETED);
    }

    public String getPostingId() {
        return this.postingId;
    }

    public void setPostingId(String postingId) {
        this.postingId = postingId;
    }

    public String getCommentId() {
        return this.commentId;
    }

    public void setCommentId(String commentId) {
        this.commentId = commentId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getOwnerFullName() {
        return this.ownerFullName;
    }

    public void setOwnerFullName(String ownerFullName) {
        this.ownerFullName = ownerFullName;
    }

    public String getOwnerGender() {
        return this.ownerGender;
    }

    public void setOwnerGender(String ownerGender) {
        this.ownerGender = ownerGender;
    }

    public AvatarImage getOwnerAvatar() {
        return this.ownerAvatar;
    }

    public void setOwnerAvatar(AvatarImage ownerAvatar) {
        this.ownerAvatar = ownerAvatar;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void setNegative(boolean negative) {
        this.negative = negative;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.maxSize(this.postingId, 40, "reaction.posting-id.wrong-size");
        ValidationUtil.maxSize(this.commentId, 40, "reaction.comment-id.wrong-size");
        ValidationUtil.maxSize(this.ownerName, 63, "reaction.owner-name.wrong-size");
        ValidationUtil.maxSize(this.ownerFullName, 96, "reaction.owner-full-name.wrong-size");
        ValidationUtil.maxSize(this.ownerGender, 31, "reaction.owner-gender.wrong-size");
    }

    @Override
    public void logParameters(List<LogPair> parameters) {
        super.logParameters(parameters);
        parameters.add(LogPair.of("postingId", LogUtil.format(this.postingId)));
        parameters.add(LogPair.of("commentId", LogUtil.format(this.commentId)));
        parameters.add(LogPair.of("ownerName", LogUtil.format(this.ownerName)));
        parameters.add(LogPair.of("negative", LogUtil.format(this.negative)));
    }
}

