/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.notifications.LogPair;
import org.moera.lib.node.types.notifications.Notification;
import org.moera.lib.node.types.notifications.NotificationType;
import org.moera.lib.node.types.validate.ValidationUtil;
import org.moera.lib.util.LogUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FriendGroupDeletedNotification
extends Notification {
    private String friendGroupId;

    public FriendGroupDeletedNotification() {
        super(NotificationType.FRIEND_GROUP_DELETED);
    }

    public String getFriendGroupId() {
        return this.friendGroupId;
    }

    public void setFriendGroupId(String friendGroupId) {
        this.friendGroupId = friendGroupId;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.maxSize(this.friendGroupId, 40, "friend-group.friend-group-id.wrong-size");
    }

    @Override
    public void logParameters(List<LogPair> parameters) {
        super.logParameters(parameters);
        parameters.add(LogPair.of("friendGroupId", LogUtil.format(this.friendGroupId)));
    }
}

