/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.notifications.LogPair;
import org.moera.lib.node.types.notifications.NotificationType;
import org.moera.lib.node.types.notifications.PostingSubscriberNotification;
import org.moera.lib.node.types.notifications.SubscriberNotification;
import org.moera.lib.node.types.validate.ValidationUtil;
import org.moera.lib.util.LogUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PostingMediaTextUpdatedNotification
extends SubscriberNotification
implements PostingSubscriberNotification {
    private String postingId;
    private String mediaId;
    private String textContent;

    public PostingMediaTextUpdatedNotification() {
        super(NotificationType.POSTING_MEDIA_TEXT_UPDATED);
    }

    @Override
    public String getPostingId() {
        return this.postingId;
    }

    public void setPostingId(String postingId) {
        this.postingId = postingId;
    }

    public String getMediaId() {
        return this.mediaId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public void setTextContent(String textContent) {
        this.textContent = textContent;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.maxSize(this.postingId, 40, "posting.posting-id.wrong-size");
        ValidationUtil.maxSize(this.mediaId, 40, "media.media-id.wrong-size");
        ValidationUtil.maxSize(this.textContent, 16384, "media.text-content.wrong-size");
    }

    @Override
    public void logParameters(List<LogPair> parameters) {
        super.logParameters(parameters);
        parameters.add(LogPair.of("postingId", LogUtil.format(this.postingId)));
        parameters.add(LogPair.of("mediaId", LogUtil.format(this.mediaId)));
        parameters.add(LogPair.of("textContent", LogUtil.format(this.textContent)));
    }
}

