/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.notifications.LogPair;
import org.moera.lib.node.types.notifications.NotificationType;
import org.moera.lib.node.types.notifications.SubscriberNotification;
import org.moera.lib.node.types.validate.ValidationUtil;
import org.moera.lib.util.LogUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UserListItemAddedNotification
extends SubscriberNotification {
    private String listName;
    private String nodeName;

    public UserListItemAddedNotification() {
        super(NotificationType.USER_LIST_ITEM_ADDED);
    }

    public String getListName() {
        return this.listName;
    }

    public void setListName(String listName) {
        this.listName = listName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.maxSize(this.listName, 63, "user-list.list-name.wrong-size");
        ValidationUtil.maxSize(this.nodeName, 63, "user-list.node-name.wrong-size");
    }

    @Override
    public void logParameters(List<LogPair> parameters) {
        super.logParameters(parameters);
        parameters.add(LogPair.of("listName", LogUtil.format(this.listName)));
        parameters.add(LogPair.of("nodeName", LogUtil.format(this.nodeName)));
    }
}

