package org.moera.lib.jsonrpc;

/**
 * Represents an exception thrown to indicate a connection-related issue
 * during a JSON-RPC communication.
 */
public class JsonRpcConnectionException extends RuntimeException {

    /**
     * Constructs a new {@code JsonRpcConnectionException} with the specified detail message.
     *
     * @param message the detail message explaining the reason for the exception
     */
    public JsonRpcConnectionException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code JsonRpcConnectionException} with the specified detail message
     * and cause.
     *
     * @param message the detail message explaining the reason for the exception
     * @param cause the cause of the exception
     */
    public JsonRpcConnectionException(String message, Throwable cause) {
        super(message, cause);
    }

}
