/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types.notifications;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import org.moera.lib.node.types.BlockedOperation;
import org.moera.lib.node.types.SearchContentUpdateType;
import org.moera.lib.node.types.notifications.LogPair;
import org.moera.lib.node.types.notifications.NotificationType;
import org.moera.lib.node.types.notifications.SubscriberNotification;
import org.moera.lib.node.types.validate.ValidationUtil;
import org.moera.lib.util.LogUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchContentUpdatedNotification
extends SubscriberNotification {
    private SearchContentUpdateType updateType;
    private String nodeName;
    private String feedName;
    private BlockedOperation blockedOperation;

    public SearchContentUpdatedNotification() {
        super(NotificationType.SEARCH_CONTENT_UPDATED);
    }

    public SearchContentUpdateType getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(SearchContentUpdateType updateType) {
        this.updateType = updateType;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getFeedName() {
        return this.feedName;
    }

    public void setFeedName(String feedName) {
        this.feedName = feedName;
    }

    public BlockedOperation getBlockedOperation() {
        return this.blockedOperation;
    }

    public void setBlockedOperation(BlockedOperation blockedOperation) {
        this.blockedOperation = blockedOperation;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.notNull((Object)this.updateType, "search.update-type.missing");
        ValidationUtil.maxSize(this.nodeName, 40, "search.node-name.wrong-size");
        ValidationUtil.maxSize(this.feedName, 63, "search.feed-name.wrong-size");
    }

    @Override
    public void logParameters(List<LogPair> parameters) {
        super.logParameters(parameters);
        parameters.add(LogPair.of("updateType", LogUtil.format(this.updateType.toString())));
        parameters.add(LogPair.of("nodeName", LogUtil.format(this.nodeName)));
        parameters.add(LogPair.of("feedName", LogUtil.format(this.feedName)));
    }
}

