/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.moera.lib.node.types.Structure;
import org.moera.lib.node.types.validate.ValidationUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AcceptedReactions
extends Structure
implements Cloneable {
    private String positive;
    private String negative;

    public String getPositive() {
        return this.positive;
    }

    public void setPositive(String positive) {
        this.positive = positive;
    }

    public String getNegative() {
        return this.negative;
    }

    public void setNegative(String negative) {
        this.negative = negative;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.maxSize(this.positive, 255, "accepted-reactions.positive.wrong-size");
        ValidationUtil.emojiList(this.positive, "accepted-reactions.positive.invalid");
        ValidationUtil.maxSize(this.negative, 255, "accepted-reactions.negative.wrong-size");
        ValidationUtil.emojiList(this.negative, "accepted-reactions.negative.invalid");
    }

    public AcceptedReactions clone() {
        try {
            return (AcceptedReactions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Must implement Cloneable", e);
        }
    }
}

