/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.moera.lib.node.types.AvatarImage;
import org.moera.lib.node.types.Structure;
import org.moera.lib.node.types.validate.ValidationUtil;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NotificationPacket
extends Structure
implements Cloneable {
    private String id;
    private String nodeName;
    private String fullName;
    private String gender;
    private AvatarImage avatar;
    private long createdAt;
    private String type;
    private String notification;
    private byte[] signature;
    private short signatureVersion;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public AvatarImage getAvatar() {
        return this.avatar;
    }

    public void setAvatar(AvatarImage avatar) {
        this.avatar = avatar;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getNotification() {
        return this.notification;
    }

    public void setNotification(String notification) {
        this.notification = notification;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public short getSignatureVersion() {
        return this.signatureVersion;
    }

    public void setSignatureVersion(short signatureVersion) {
        this.signatureVersion = signatureVersion;
    }

    @Override
    public void validate() {
        super.validate();
        ValidationUtil.notBlank(this.nodeName, "notification.node-name.blank");
        ValidationUtil.maxSize(this.nodeName, 63, "notification.node-name.wrong-size");
        ValidationUtil.maxSize(this.fullName, 96, "notification.full-name.wrong-size");
        ValidationUtil.maxSize(this.gender, 31, "notification.gender.wrong-size");
        ValidationUtil.notBlank(this.type, "notification.type.blank");
        ValidationUtil.notBlank(this.notification, "notification.notification.blank");
    }

    public NotificationPacket clone() {
        try {
            return (NotificationPacket)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Must implement Cloneable", e);
        }
    }
}

