/*
 * Decompiled with CFR 0.152.
 */
package org.moera.lib.node.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public enum Scope {
    NONE(0L, false),
    IDENTIFY(0L, false),
    OTHER(1L, true),
    VIEW_MEDIA(2L, true),
    VIEW_CONTENT(4L, true),
    ADD_POST(8L, true),
    UPDATE_POST(16L, true),
    ADD_COMMENT(32L, true),
    UPDATE_COMMENT(64L, true),
    REACT(128L, true),
    DELETE_OWN_CONTENT(256L, true),
    DELETE_OTHERS_CONTENT(512L, true),
    VIEW_PEOPLE(1024L, true),
    BLOCK(2048L, true),
    FRIEND(4096L, true),
    REMOTE_IDENTIFY(8192L, true),
    DRAFTS(16384L, true),
    VIEW_FEEDS(32768L, true),
    UPDATE_FEEDS(65536L, true),
    NAME(131072L, true),
    PLUGINS(262144L, true),
    VIEW_PROFILE(524288L, true),
    UPDATE_PROFILE(0x100000L, true),
    SHERIFF(0x200000L, true),
    VIEW_SETTINGS(0x400000L, true),
    UPDATE_SETTINGS(0x800000L, true),
    SUBSCRIBE(0x1000000L, true),
    TOKENS(0x2000000L, true),
    USER_LISTS(0x4000000L, true),
    GRANT(0x8000000L, true),
    UPLOAD_PUBLIC_MEDIA(0x10000000L, true),
    UPLOAD_PRIVATE_MEDIA(0x20000000L, true),
    REMOTE_ADD_POST(8200L, false),
    REMOTE_UPDATE_POST(8208L, false),
    REMOTE_ADD_COMMENT(8224L, false),
    REMOTE_UPDATE_COMMENT(8256L, false),
    REMOTE_REACT(8320L, false),
    REMOTE_DELETE_CONTENT(8448L, false),
    VIEW_ALL(558086L, false),
    ALL(0x3FFFFFFFL, false);

    private final long mask;
    private final boolean basic;

    private Scope(long mask, boolean basic) {
        this.mask = mask;
        this.basic = basic;
    }

    public long getMask() {
        return this.mask;
    }

    public boolean isBasic() {
        return this.basic;
    }

    public boolean included(long mask) {
        return (mask & this.getMask()) == this.getMask();
    }

    public boolean included(Scope scope) {
        return this.included(scope.getMask());
    }

    public static long of(Scope ... scopes) {
        long mask = 0L;
        for (Scope scope : scopes) {
            mask |= scope.getMask();
        }
        return mask;
    }

    @JsonValue
    public String getValue() {
        return this.name().toLowerCase().replace('_', '-');
    }

    public static String toValue(Scope scope) {
        return scope != null ? scope.getValue() : null;
    }

    public static Scope forValue(String value) {
        try {
            return Scope.parse(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @JsonCreator
    public static Scope parse(String value) {
        return Scope.valueOf(value.toUpperCase().replace('-', '_'));
    }

    public static List<String> toValues(long mask) {
        ArrayList<String> values = new ArrayList<String>();
        for (Scope scope : Scope.values()) {
            if (!scope.isBasic() || (scope.getMask() & mask) == 0L) continue;
            values.add(scope.getValue());
        }
        return values;
    }

    public static long forValues(Collection<String> values) {
        if (values == null) {
            return 0L;
        }
        long mask = 0L;
        for (String value : values) {
            Scope scope = Scope.forValue(value);
            if (scope == null) continue;
            mask |= scope.getMask();
        }
        return mask;
    }
}

